/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.slf4j.helpers.MessageFormatter;

public abstract class ApplicationEntity
extends MimeEntity {
    protected static final String CONTENT_DISPOSITION_PATTERN = "attachment; filename={}";
    private final String ediMessage;

    protected ApplicationEntity(String ediMessage, ContentType contentType, String contentTransferEncoding, boolean isMainBody, String filename) {
        super(contentType, contentTransferEncoding);
        this.ediMessage = ObjectHelper.notNull(ediMessage, "EDI Message");
        this.setMainBody(isMainBody);
        if (StringUtils.isNotBlank(filename)) {
            this.addHeader("Content-Disposition", MessageFormatter.format((String)CONTENT_DISPOSITION_PATTERN, (Object)filename).getMessage());
        }
    }

    public String getEdiMessage() {
        return this.ediMessage;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());
             OutputStream transferEncodedStream = EntityUtils.encode(canonicalOutstream, this.getContentTransferEncodingValue());){
            if (!this.isMainBody()) {
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            transferEncodedStream.write(this.ediMessage.getBytes(this.getCharset()), 0, this.ediMessage.length());
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }
}

