/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;

public abstract class MultipartMimeEntity
extends MimeEntity {
    protected String boundary;
    private final List<MimeEntity> parts = new ArrayList<MimeEntity>();

    protected MultipartMimeEntity(ContentType contentType, String contentTransferEncoding) {
        super(contentType, contentTransferEncoding);
    }

    protected MultipartMimeEntity(AS2SignedDataGenerator signer, boolean isMainBody, String boundary) {
        this(signer.createMultipartSignedContentType(boundary), null, isMainBody, boundary);
    }

    protected MultipartMimeEntity(ContentType contentType, String contentTransferEncoding, boolean isMainBody, String boundary) {
        super(contentType, contentTransferEncoding);
        this.setMainBody(isMainBody);
        this.boundary = boundary != null ? boundary : EntityUtils.createBoundaryValue();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void addPart(MimeEntity part) {
        this.parts.add(part);
        this.contentLength = -2L;
    }

    public MimeEntity getPart(int index) {
        return this.parts.get(index);
    }

    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == -2L) {
            for (MimeEntity part : this.parts) {
                long len = part.getContentLength();
                if (len >= 0L) continue;
                this.contentLength = -1L;
                return this.contentLength;
            }
            this.contentLength = super.getContentLength();
        }
        return this.contentLength;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, this.getCharset());){
            if (!this.isMainBody()) {
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            String boundary = "--" + this.boundary;
            for (MimeEntity part : this.parts) {
                canonicalOutstream.writeln(boundary);
                part.writeTo(outstream);
                canonicalOutstream.writeln();
            }
            canonicalOutstream.writeln(boundary + "--");
        }
    }
}

