/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.protocol;

import java.io.IOException;
import org.apache.camel.component.as2.api.InvalidAS2NameException;
import org.apache.camel.component.as2.api.util.AS2Utils;
import org.apache.camel.util.StringHelper;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;

public class RequestAS2
implements HttpRequestInterceptor {
    private final String as2Version;
    private final String clientFQDN;

    public RequestAS2(String as2Version, String clientFQDN) {
        this.as2Version = as2Version;
        this.clientFQDN = clientFQDN;
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        request.addHeader("MIME-Version", "1.0");
        String subject = coreContext.getAttribute("camel-as2.client.subject", String.class);
        request.addHeader("Subject", subject);
        String from = coreContext.getAttribute("camel-as2.client.from", String.class);
        request.addHeader("From", from);
        request.addHeader("AS2-Version", this.as2Version);
        String as2From = coreContext.getAttribute("camel-as2.client.as2-from", String.class);
        try {
            AS2Utils.validateAS2Name(as2From);
        }
        catch (InvalidAS2NameException e) {
            throw new HttpException("Invalid AS-From name", e);
        }
        request.addHeader("AS2-From", as2From);
        String as2To = coreContext.getAttribute("camel-as2.client.as2-to", String.class);
        try {
            AS2Utils.validateAS2Name(as2To);
        }
        catch (InvalidAS2NameException e) {
            throw new HttpException("Invalid AS-To name", e);
        }
        request.addHeader("AS2-To", as2To);
        String receiptDeliveryOption = coreContext.getAttribute("camel-as2.client.Receipt-Delivery-Option", String.class);
        if (StringHelper.trimToNull(receiptDeliveryOption) != null) {
            request.addHeader("Receipt-Delivery-Option", receiptDeliveryOption);
        }
        request.addHeader("Message-Id", AS2Utils.createMessageId(this.clientFQDN));
    }
}

