/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.HttpException;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;

public final class EncryptingUtils {
    private EncryptingUtils() {
    }

    public static CMSEnvelopedDataGenerator createEnvelopDataGenerator(Certificate[] encryptionCertificateChain) throws HttpException {
        ObjectHelper.notNull(encryptionCertificateChain, "encryptionCertificateChain");
        if (encryptionCertificateChain.length == 0 || !(encryptionCertificateChain[0] instanceof X509Certificate)) {
            throw new IllegalArgumentException("Invalid certificate chain");
        }
        try {
            X509Certificate encryptionCertificate = (X509Certificate)encryptionCertificateChain[0];
            CMSEnvelopedDataGenerator cmsEnvelopeDataGenerator = new CMSEnvelopedDataGenerator();
            JceKeyTransRecipientInfoGenerator recipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(encryptionCertificate);
            cmsEnvelopeDataGenerator.addRecipientInfoGenerator(recipientInfoGenerator);
            return cmsEnvelopeDataGenerator;
        }
        catch (CertificateEncodingException e) {
            throw new HttpException("Failed to create envelope data generator", e);
        }
    }

    public static OutputEncryptor createEncryptor(AS2EncryptionAlgorithm encryptionAlgorithm) throws HttpException {
        ObjectHelper.notNull(encryptionAlgorithm, "encryptionAlgorithmName");
        try {
            return new JceCMSContentEncryptorBuilder(encryptionAlgorithm.getAlgorithmOID()).build();
        }
        catch (CMSException e) {
            throw new HttpException("Failed to create encryptor ", e);
        }
    }
}

