/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.crypto.bike.BIKEEngine;
import org.bouncycastle.pqc.crypto.bike.BIKEKeyParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import org.bouncycastle.util.Arrays;

public class BIKEKEMExtractor
implements EncapsulatedSecretExtractor {
    private BIKEEngine engine;
    private BIKEKeyParameters key;

    public BIKEKEMExtractor(BIKEPrivateKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(BIKEParameters param) {
        this.engine = param.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        byte[] session_key = new byte[this.engine.getSessionKeySize()];
        BIKEPrivateKeyParameters secretKey = (BIKEPrivateKeyParameters)this.key;
        byte[] c0 = Arrays.copyOfRange(encapsulation, 0, secretKey.getParameters().getRByte());
        byte[] c1 = Arrays.copyOfRange(encapsulation, secretKey.getParameters().getRByte(), encapsulation.length);
        byte[] h0 = secretKey.getH0();
        byte[] h1 = secretKey.getH1();
        byte[] sigma = secretKey.getSigma();
        this.engine.decaps(session_key, h0, h1, sigma, c0, c1);
        return Arrays.copyOfRange(session_key, 0, this.key.getParameters().getSessionKeySize() / 8);
    }

    @Override
    public int getEncapsulationLength() {
        return this.key.getParameters().getRByte() + this.key.getParameters().getLByte();
    }
}

