/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import java.security.SecureRandom;
import org.bouncycastle.pqc.crypto.falcon.FalconCodec;
import org.bouncycastle.pqc.crypto.falcon.FalconCommon;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;
import org.bouncycastle.pqc.crypto.falcon.FalconKeyGen;
import org.bouncycastle.pqc.crypto.falcon.FalconSign;
import org.bouncycastle.pqc.crypto.falcon.FalconVrfy;
import org.bouncycastle.pqc.crypto.falcon.SHAKE256;
import org.bouncycastle.util.Arrays;

class FalconNIST {
    int NONCELEN;
    int LOGN;
    private int N;
    private SecureRandom rand;
    private int CRYPTO_SECRETKEYBYTES;
    private int CRYPTO_PUBLICKEYBYTES;
    int CRYPTO_BYTES;
    private FalconCodec codec = new FalconCodec();

    FalconNIST(int logn, int noncelen, SecureRandom random) {
        this.rand = random;
        this.LOGN = logn;
        this.NONCELEN = noncelen;
        this.N = 1 << logn;
        this.CRYPTO_PUBLICKEYBYTES = 1 + 14 * this.N / 8;
        if (logn == 10) {
            this.CRYPTO_SECRETKEYBYTES = 2305;
            this.CRYPTO_BYTES = 1330;
        } else if (logn == 9 || logn == 8) {
            this.CRYPTO_SECRETKEYBYTES = 1 + 6 * this.N * 2 / 8 + this.N;
            this.CRYPTO_BYTES = 690;
        } else if (logn == 7 || logn == 6) {
            this.CRYPTO_SECRETKEYBYTES = 1 + 7 * this.N * 2 / 8 + this.N;
            this.CRYPTO_BYTES = 690;
        } else {
            this.CRYPTO_SECRETKEYBYTES = 1 + this.N * 2 + this.N;
            this.CRYPTO_BYTES = 690;
        }
    }

    byte[][] crypto_sign_keypair(byte[] srcpk, int pk, byte[] srcsk, int sk) {
        byte[] f = new byte[this.N];
        byte[] g = new byte[this.N];
        byte[] F2 = new byte[this.N];
        short[] h = new short[this.N];
        byte[] seed = new byte[48];
        SHAKE256 rng = new SHAKE256();
        FalconKeyGen keygen = new FalconKeyGen();
        this.rand.nextBytes(seed);
        rng.inner_shake256_init();
        rng.inner_shake256_inject(seed, 0, seed.length);
        rng.i_shake256_flip();
        keygen.keygen(rng, f, 0, g, 0, F2, 0, null, 0, h, 0, this.LOGN);
        srcsk[sk + 0] = (byte)(80 + this.LOGN);
        int u = 1;
        int v = this.codec.trim_i8_encode(srcsk, sk + u, this.CRYPTO_SECRETKEYBYTES - u, f, 0, this.LOGN, this.codec.max_fg_bits[this.LOGN]);
        if (v == 0) {
            throw new IllegalStateException("f encode failed");
        }
        byte[] fEnc = Arrays.copyOfRange(srcsk, sk + u, u + v);
        if ((v = this.codec.trim_i8_encode(srcsk, sk + (u += v), this.CRYPTO_SECRETKEYBYTES - u, g, 0, this.LOGN, this.codec.max_fg_bits[this.LOGN])) == 0) {
            throw new IllegalStateException("g encode failed");
        }
        byte[] gEnc = Arrays.copyOfRange(srcsk, sk + u, u + v);
        if ((v = this.codec.trim_i8_encode(srcsk, sk + (u += v), this.CRYPTO_SECRETKEYBYTES - u, F2, 0, this.LOGN, this.codec.max_FG_bits[this.LOGN])) == 0) {
            throw new IllegalStateException("F encode failed");
        }
        byte[] FEnc = Arrays.copyOfRange(srcsk, sk + u, u + v);
        if ((u += v) != this.CRYPTO_SECRETKEYBYTES) {
            throw new IllegalStateException("secret key encoding failed");
        }
        srcpk[pk + 0] = (byte)(0 + this.LOGN);
        v = this.codec.modq_encode(srcpk, pk + 1, this.CRYPTO_PUBLICKEYBYTES - 1, h, 0, this.LOGN);
        if (v != this.CRYPTO_PUBLICKEYBYTES - 1) {
            throw new IllegalStateException("public key encoding failed");
        }
        return new byte[][]{Arrays.copyOfRange(srcpk, 1, srcpk.length), fEnc, gEnc, FEnc};
    }

    byte[] crypto_sign(boolean attached, byte[] srcsm, byte[] srcm, int m, int mlen, byte[] srcsk, int sk) {
        int sig_len;
        byte[] f = new byte[this.N];
        byte[] g = new byte[this.N];
        byte[] F2 = new byte[this.N];
        byte[] G = new byte[this.N];
        short[] sig = new short[this.N];
        short[] hm = new short[this.N];
        byte[] seed = new byte[48];
        byte[] nonce = new byte[this.NONCELEN];
        SHAKE256 sc = new SHAKE256();
        FalconSign sign = new FalconSign();
        FalconVrfy vrfy = new FalconVrfy();
        FalconCommon common = new FalconCommon();
        int u = 0;
        int v = this.codec.trim_i8_decode(f, 0, this.LOGN, this.codec.max_fg_bits[this.LOGN], srcsk, sk + u, this.CRYPTO_SECRETKEYBYTES - u);
        if (v == 0) {
            throw new IllegalStateException("f decode failed");
        }
        if ((v = this.codec.trim_i8_decode(g, 0, this.LOGN, this.codec.max_fg_bits[this.LOGN], srcsk, sk + (u += v), this.CRYPTO_SECRETKEYBYTES - u)) == 0) {
            throw new IllegalStateException("g decode failed");
        }
        if ((v = this.codec.trim_i8_decode(F2, 0, this.LOGN, this.codec.max_FG_bits[this.LOGN], srcsk, sk + (u += v), this.CRYPTO_SECRETKEYBYTES - u)) == 0) {
            throw new IllegalArgumentException("F decode failed");
        }
        if ((u += v) != this.CRYPTO_SECRETKEYBYTES - 1) {
            throw new IllegalStateException("full key not used");
        }
        if (!vrfy.complete_private(G, 0, f, 0, g, 0, F2, 0, this.LOGN, new short[2 * this.N], 0)) {
            throw new IllegalStateException("complete_private failed");
        }
        this.rand.nextBytes(nonce);
        sc.inner_shake256_init();
        sc.inner_shake256_inject(nonce, 0, this.NONCELEN);
        sc.inner_shake256_inject(srcm, m, mlen);
        sc.i_shake256_flip();
        common.hash_to_point_vartime(sc, hm, 0, this.LOGN);
        this.rand.nextBytes(seed);
        sc.inner_shake256_init();
        sc.inner_shake256_inject(seed, 0, seed.length);
        sc.i_shake256_flip();
        sign.sign_dyn(sig, 0, sc, f, 0, g, 0, F2, 0, G, 0, hm, 0, this.LOGN, new FalconFPR[10 * this.N], 0);
        byte[] esig = new byte[this.CRYPTO_BYTES - 2 - this.NONCELEN];
        if (attached) {
            esig[0] = (byte)(32 + this.LOGN);
            sig_len = this.codec.comp_encode(esig, 1, esig.length - 1, sig, 0, this.LOGN);
            if (sig_len == 0) {
                throw new IllegalStateException("signature failed to generate");
            }
            ++sig_len;
        } else {
            sig_len = this.codec.comp_encode(esig, 0, esig.length, sig, 0, this.LOGN);
            if (sig_len == 0) {
                throw new IllegalStateException("signature failed to generate");
            }
        }
        srcsm[0] = (byte)(48 + this.LOGN);
        System.arraycopy(nonce, 0, srcsm, 1, this.NONCELEN);
        System.arraycopy(esig, 0, srcsm, 1 + this.NONCELEN, sig_len);
        return Arrays.copyOfRange(srcsm, 0, 1 + this.NONCELEN + sig_len);
    }

    int crypto_sign_open(boolean attached, byte[] sig_encoded, byte[] nonce, byte[] msg, byte[] srcpk, int pk) {
        short[] h = new short[this.N];
        short[] hm = new short[this.N];
        short[] sig = new short[this.N];
        SHAKE256 sc = new SHAKE256();
        FalconVrfy vrfy = new FalconVrfy();
        FalconCommon common = new FalconCommon();
        if (this.codec.modq_decode(h, 0, this.LOGN, srcpk, pk, this.CRYPTO_PUBLICKEYBYTES - 1) != this.CRYPTO_PUBLICKEYBYTES - 1) {
            return -1;
        }
        vrfy.to_ntt_monty(h, 0, this.LOGN);
        int sig_len = sig_encoded.length;
        int msg_len = msg.length;
        if (attached) {
            if (sig_len < 1 || sig_encoded[0] != (byte)(32 + this.LOGN)) {
                return -1;
            }
            if (this.codec.comp_decode(sig, 0, this.LOGN, sig_encoded, 1, sig_len - 1) != sig_len - 1) {
                return -1;
            }
        } else if (sig_len < 1 || this.codec.comp_decode(sig, 0, this.LOGN, sig_encoded, 0, sig_len) != sig_len) {
            return -1;
        }
        sc.inner_shake256_init();
        sc.inner_shake256_inject(nonce, 0, this.NONCELEN);
        sc.inner_shake256_inject(msg, 0, msg_len);
        sc.i_shake256_flip();
        common.hash_to_point_vartime(sc, hm, 0, this.LOGN);
        if (vrfy.verify_raw(hm, 0, sig, 0, h, 0, this.LOGN, new short[this.N], 0) == 0) {
            return -1;
        }
        return 0;
    }
}

