/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.ntru;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.KEM;
import javax.crypto.KEMSpi;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import org.bouncycastle.pqc.jcajce.provider.Util;
import org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPublicKey;

public class NTRUEncapsulatorSpi
implements KEMSpi.EncapsulatorSpi {
    private final BCNTRUPublicKey publicKey;
    private final KTSParameterSpec parameterSpec;
    private final NTRUKEMGenerator kemGen;

    public NTRUEncapsulatorSpi(BCNTRUPublicKey publicKey, KTSParameterSpec parameterSpec, SecureRandom random) {
        this.publicKey = publicKey;
        this.parameterSpec = parameterSpec;
        this.kemGen = new NTRUKEMGenerator(random);
    }

    @Override
    public KEM.Encapsulated engineEncapsulate(int from, int to, String algorithm) {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        SecretWithEncapsulation secEnc = this.kemGen.generateEncapsulated(this.publicKey.getKeyParams());
        byte[] encapsulation = secEnc.getEncapsulation();
        byte[] secret = secEnc.getSecret();
        if (useKDF) {
            try {
                secret = Util.makeKeyBytes((KTSParameterSpec)this.parameterSpec, (byte[])secret);
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException(e);
            }
        }
        byte[] secretKey = Arrays.copyOfRange(secret, from, to);
        return new KEM.Encapsulated(new SecretKeySpec(secretKey, algorithm), encapsulation, null);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        switch (this.publicKey.getKeyParams().getParameters().getName()) {
            case "ntruhps2048509": {
                return 699;
            }
            case "ntruhps2048677": {
                return 930;
            }
            case "ntruhps4096821": {
                return 1230;
            }
            case "ntruhps40961229": {
                return 1843;
            }
            case "ntruhrss701": {
                return 1138;
            }
            case "ntruhrss1373": {
                return 2401;
            }
        }
        return -1;
    }
}

