/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber;

import com.beanit.asn1bean.util.HexString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerLength
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int val;

    public static int encodeLength(OutputStream reverseOS, int length) throws IOException {
        if (length <= 127) {
            reverseOS.write(length);
            return 1;
        }
        if (length <= 255) {
            reverseOS.write(length);
            reverseOS.write(129);
            return 2;
        }
        if (length <= 65535) {
            reverseOS.write(length);
            reverseOS.write(length >> 8);
            reverseOS.write(130);
            return 3;
        }
        if (length <= 0xFFFFFF) {
            reverseOS.write(length);
            reverseOS.write(length >> 8);
            reverseOS.write(length >> 16);
            reverseOS.write(131);
            return 4;
        }
        int numLengthBytes = 1;
        while ((int)(Math.pow(2.0, 8 * numLengthBytes) - 1.0) < length) {
            ++numLengthBytes;
        }
        for (int i = 0; i < numLengthBytes; ++i) {
            reverseOS.write(length >> 8 * i);
        }
        reverseOS.write(0x80 | numLengthBytes);
        return 1 + numLengthBytes;
    }

    public static int readEocByte(InputStream is) throws IOException {
        int b = is.read();
        if (b != 0) {
            if (b == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            throw new IOException("Byte " + HexString.fromByte(b) + " does not match end of contents octet of zero.");
        }
        return 1;
    }

    public static int readEocByte(InputStream is, OutputStream os) throws IOException {
        int b = is.read();
        if (b != 0) {
            if (b == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            os.write(b);
            throw new IOException("Byte " + HexString.fromByte(b) + " does not match end of contents octet of zero.");
        }
        os.write(b);
        return 1;
    }

    public int decode(InputStream is) throws IOException {
        this.val = is.read();
        if (this.val < 128) {
            if (this.val == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            return 1;
        }
        int lengthLength = this.val & 0x7F;
        if (lengthLength == 0) {
            this.val = -1;
            return 1;
        }
        if (lengthLength > 4) {
            throw new IOException("Length is out of bounds: " + lengthLength);
        }
        this.val = 0;
        for (int i = 0; i < lengthLength; ++i) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            this.val |= nextByte << 8 * (lengthLength - i - 1);
        }
        return lengthLength + 1;
    }

    public int decode(InputStream is, OutputStream os) throws IOException {
        this.val = is.read();
        if (this.val == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        os.write(this.val);
        if (this.val < 128) {
            return 1;
        }
        int lengthLength = this.val & 0x7F;
        if (lengthLength == 0) {
            this.val = -1;
            return 1;
        }
        if (lengthLength > 4) {
            throw new IOException("Length is out of bounds: " + lengthLength);
        }
        this.val = 0;
        for (int i = 0; i < lengthLength; ++i) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            os.write(nextByte);
            this.val |= nextByte << 8 * (lengthLength - i - 1);
        }
        return lengthLength + 1;
    }

    public int readEocIfIndefinite(InputStream is) throws IOException {
        if (this.val >= 0) {
            return 0;
        }
        BerLength.readEocByte(is);
        BerLength.readEocByte(is);
        return 2;
    }
}

