/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber.types;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerInteger;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.BerObjectIdentifier;
import com.beanit.asn1bean.ber.types.BerOctetString;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.asn1bean.ber.types.string.BerObjectDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerEmbeddedPdv
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 11);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Identification identification = null;
    private BerObjectDescriptor dataValueDescriptor = null;
    private BerOctetString dataValue = null;

    public BerEmbeddedPdv() {
    }

    public BerEmbeddedPdv(byte[] code) {
        this.code = code;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public void setIdentification(Identification identification) {
        this.identification = identification;
    }

    public BerObjectDescriptor getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public void setDataValueDescriptor(BerObjectDescriptor dataValueDescriptor) {
        this.dataValueDescriptor = dataValueDescriptor;
    }

    public BerOctetString getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(BerOctetString dataValue) {
        this.dataValue = dataValue;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.dataValue.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        if (this.dataValueDescriptor != null) {
            codeLength += this.dataValueDescriptor.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
        }
        int sublength = this.identification.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength(reverseOS, sublength);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            vByteCount += length.decode(is);
            this.identification = new Identification();
            vByteCount += this.identification.decode(is, null);
            vByteCount += length.readEocIfIndefinite(is);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.dataValueDescriptor = new BerObjectDescriptor();
            vByteCount += this.dataValueDescriptor.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 2)) {
            this.dataValue = new BerOctetString();
            if (lengthVal >= 0 && (vByteCount += this.dataValue.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.identification != null) {
            sb.append("identification: ");
            this.identification.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("identification: <empty-required-field>");
        }
        if (this.dataValueDescriptor != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("dataValueDescriptor: ").append(this.dataValueDescriptor);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.dataValue != null) {
            sb.append("dataValue: ").append(this.dataValue);
        } else {
            sb.append("dataValue: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class Identification
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Syntaxes syntaxes = null;
        private BerObjectIdentifier syntax = null;
        private BerInteger presentationContextId = null;
        private ContextNegotiation contextNegotiation = null;
        private BerObjectIdentifier transferSyntax = null;
        private BerNull fixed = null;

        public Identification() {
        }

        public Identification(byte[] code) {
            this.code = code;
        }

        public Syntaxes getSyntaxes() {
            return this.syntaxes;
        }

        public void setSyntaxes(Syntaxes syntaxes) {
            this.syntaxes = syntaxes;
        }

        public BerObjectIdentifier getSyntax() {
            return this.syntax;
        }

        public void setSyntax(BerObjectIdentifier syntax) {
            this.syntax = syntax;
        }

        public BerInteger getPresentationContextId() {
            return this.presentationContextId;
        }

        public void setPresentationContextId(BerInteger presentationContextId) {
            this.presentationContextId = presentationContextId;
        }

        public ContextNegotiation getContextNegotiation() {
            return this.contextNegotiation;
        }

        public void setContextNegotiation(ContextNegotiation contextNegotiation) {
            this.contextNegotiation = contextNegotiation;
        }

        public BerObjectIdentifier getTransferSyntax() {
            return this.transferSyntax;
        }

        public void setTransferSyntax(BerObjectIdentifier transferSyntax) {
            this.transferSyntax = transferSyntax;
        }

        public BerNull getFixed() {
            return this.fixed;
        }

        public void setFixed(BerNull fixed) {
            this.fixed = fixed;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.fixed != null) {
                codeLength += this.fixed.encode(reverseOS, false);
                reverseOS.write(133);
                return ++codeLength;
            }
            if (this.transferSyntax != null) {
                codeLength += this.transferSyntax.encode(reverseOS, false);
                reverseOS.write(132);
                return ++codeLength;
            }
            if (this.contextNegotiation != null) {
                codeLength += this.contextNegotiation.encode(reverseOS, false);
                reverseOS.write(163);
                return ++codeLength;
            }
            if (this.presentationContextId != null) {
                codeLength += this.presentationContextId.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.syntax != null) {
                codeLength += this.syntax.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.syntaxes != null) {
                codeLength += this.syntaxes.encode(reverseOS, false);
                reverseOS.write(160);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 0)) {
                this.syntaxes = new Syntaxes();
                return tlvByteCount += this.syntaxes.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.syntax = new BerObjectIdentifier();
                return tlvByteCount += this.syntax.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.presentationContextId = new BerInteger();
                return tlvByteCount += this.presentationContextId.decode(is, false);
            }
            if (berTag.equals(128, 32, 3)) {
                this.contextNegotiation = new ContextNegotiation();
                return tlvByteCount += this.contextNegotiation.decode(is, false);
            }
            if (berTag.equals(128, 0, 4)) {
                this.transferSyntax = new BerObjectIdentifier();
                return tlvByteCount += this.transferSyntax.decode(is, false);
            }
            if (berTag.equals(128, 0, 5)) {
                this.fixed = new BerNull();
                return tlvByteCount += this.fixed.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.syntaxes != null) {
                sb.append("syntaxes: ");
                this.syntaxes.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.syntax != null) {
                sb.append("syntax: ").append(this.syntax);
                return;
            }
            if (this.presentationContextId != null) {
                sb.append("presentationContextId: ").append(this.presentationContextId);
                return;
            }
            if (this.contextNegotiation != null) {
                sb.append("contextNegotiation: ");
                this.contextNegotiation.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.transferSyntax != null) {
                sb.append("transferSyntax: ").append(this.transferSyntax);
                return;
            }
            if (this.fixed != null) {
                sb.append("fixed: ").append(this.fixed);
                return;
            }
            sb.append("<none>");
        }

        public static class ContextNegotiation
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private BerInteger presentationContextId = null;
            private BerObjectIdentifier transferSyntax = null;

            public ContextNegotiation() {
            }

            public ContextNegotiation(byte[] code) {
                this.code = code;
            }

            public BerInteger getPresentationContextId() {
                return this.presentationContextId;
            }

            public void setPresentationContextId(BerInteger presentationContextId) {
                this.presentationContextId = presentationContextId;
            }

            public BerObjectIdentifier getTransferSyntax() {
                return this.transferSyntax;
            }

            public void setTransferSyntax(BerObjectIdentifier transferSyntax) {
                this.transferSyntax = transferSyntax;
            }

            @Override
            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                codeLength += this.transferSyntax.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
                codeLength += this.presentationContextId.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
                codeLength += BerLength.encodeLength(reverseOS, codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            @Override
            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int tlByteCount = 0;
                int vByteCount = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    tlByteCount += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                tlByteCount += length.decode(is);
                int lengthVal = length.val;
                vByteCount += berTag.decode(is);
                if (berTag.equals(128, 0, 0)) {
                    this.presentationContextId = new BerInteger();
                    vByteCount += this.presentationContextId.decode(is, false);
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (berTag.equals(128, 0, 1)) {
                    this.transferSyntax = new BerObjectIdentifier();
                    if (lengthVal >= 0 && (vByteCount += this.transferSyntax.decode(is, false)) == lengthVal) {
                        return tlByteCount + vByteCount;
                    }
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (lengthVal < 0) {
                    if (!berTag.equals(0, 0, 0)) {
                        throw new IOException("Decoded sequence has wrong end of contents octets");
                    }
                    return tlByteCount + (vByteCount += BerLength.readEocByte(is));
                }
                throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode(reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{");
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.presentationContextId != null) {
                    sb.append("presentationContextId: ").append(this.presentationContextId);
                } else {
                    sb.append("presentationContextId: <empty-required-field>");
                }
                sb.append(",\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.transferSyntax != null) {
                    sb.append("transferSyntax: ").append(this.transferSyntax);
                } else {
                    sb.append("transferSyntax: <empty-required-field>");
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }

        public static class Syntaxes
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private BerObjectIdentifier abstract_ = null;
            private BerObjectIdentifier transfer = null;

            public Syntaxes() {
            }

            public Syntaxes(byte[] code) {
                this.code = code;
            }

            public BerObjectIdentifier getAbstract() {
                return this.abstract_;
            }

            public void setAbstract(BerObjectIdentifier abstract_) {
                this.abstract_ = abstract_;
            }

            public BerObjectIdentifier getTransfer() {
                return this.transfer;
            }

            public void setTransfer(BerObjectIdentifier transfer) {
                this.transfer = transfer;
            }

            @Override
            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                codeLength += this.transfer.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
                codeLength += this.abstract_.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
                codeLength += BerLength.encodeLength(reverseOS, codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            @Override
            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int tlByteCount = 0;
                int vByteCount = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    tlByteCount += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                tlByteCount += length.decode(is);
                int lengthVal = length.val;
                vByteCount += berTag.decode(is);
                if (berTag.equals(128, 0, 0)) {
                    this.abstract_ = new BerObjectIdentifier();
                    vByteCount += this.abstract_.decode(is, false);
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (berTag.equals(128, 0, 1)) {
                    this.transfer = new BerObjectIdentifier();
                    if (lengthVal >= 0 && (vByteCount += this.transfer.decode(is, false)) == lengthVal) {
                        return tlByteCount + vByteCount;
                    }
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (lengthVal < 0) {
                    if (!berTag.equals(0, 0, 0)) {
                        throw new IOException("Decoded sequence has wrong end of contents octets");
                    }
                    return tlByteCount + (vByteCount += BerLength.readEocByte(is));
                }
                throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode(reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{");
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.abstract_ != null) {
                    sb.append("abstract_: ").append(this.abstract_);
                } else {
                    sb.append("abstract_: <empty-required-field>");
                }
                sb.append(",\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.transfer != null) {
                    sb.append("transfer: ").append(this.transfer);
                } else {
                    sb.append("transfer: <empty-required-field>");
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }
    }
}

