/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.util;

import java.nio.ByteBuffer;
import java.util.Objects;

public class HexString {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private HexString() {
    }

    public static String fromByte(byte b) {
        return HexString.fromBytes(new byte[]{b});
    }

    public static String fromByte(int b) {
        return HexString.fromBytes(new byte[]{(byte)b});
    }

    public static String fromInt(int i) {
        byte[] bytes = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return HexString.fromBytes(bytes);
    }

    public static String fromLong(long l) {
        byte[] bytes = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return HexString.fromBytes(bytes);
    }

    public static String fromBytes(byte[] bytes) {
        return HexString.fromBytes(bytes, 0, bytes.length);
    }

    public static String fromBytesFormatted(byte[] bytes) {
        return HexString.fromBytesFormatted(bytes, 0, bytes.length);
    }

    public static String fromBytes(byte[] bytes, int offset, int length) {
        char[] hexChars = new char[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = bytes[j + offset] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String fromBytes(ByteBuffer buffer) {
        return HexString.fromBytes(buffer.array(), buffer.arrayOffset(), buffer.arrayOffset() + buffer.limit());
    }

    public static String fromBytesFormatted(byte[] bytes, int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int l = 1;
        for (int i = offset; i < offset + length; ++i) {
            if (l != 1 && (l - 1) % 8 == 0) {
                builder.append(' ');
            }
            if (l != 1 && (l - 1) % 16 == 0) {
                builder.append('\n');
            }
            ++l;
            HexString.appendFromByte(bytes[i], builder);
            if (i == offset + length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static byte[] toBytes(String hexString) {
        Objects.requireNonNull(hexString);
        if (hexString.length() == 0 || hexString.length() % 2 != 0) {
            throw new NumberFormatException("argument is not a valid hex string");
        }
        int length = hexString.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            int firstCharacter = Character.digit(hexString.charAt(i), 16);
            int secondCharacter = Character.digit(hexString.charAt(i + 1), 16);
            if (firstCharacter == -1 || secondCharacter == -1) {
                throw new NumberFormatException("argument is not a valid hex string");
            }
            data[i / 2] = (byte)((firstCharacter << 4) + secondCharacter);
        }
        return data;
    }

    public static void appendFromByte(byte b, StringBuilder builder) {
        builder.append(HexString.fromByte(b));
    }

    public static void appendFromBytes(StringBuilder builder, byte[] bytes, int offset, int length) {
        builder.append(HexString.fromBytes(bytes, offset, length));
    }
}

