/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.asn1;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.asn1.ASN1GenericIterator;
import org.apache.camel.dataformat.asn1.ASN1MessageIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;

@Dataformat(value="asn1")
public class ASN1DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;
    private Class<?> unmarshalType;

    public ASN1DataFormat() {
        this.usingIterator = false;
    }

    public ASN1DataFormat(Class<?> unmarshalType) {
        this.usingIterator = true;
        this.unmarshalType = unmarshalType;
    }

    @Override
    public String getDataFormatName() {
        return "asn1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ByteArrayInputStream berOut = null;
        if (this.usingIterator) {
            if (this.unmarshalType != null) {
                this.encodeGenericTypeObject(exchange, stream);
                return;
            }
            Object body = exchange.getIn().getBody();
            if (body instanceof ASN1Primitive) {
                ASN1Primitive asn1Primitive = ObjectHelper.cast(ASN1Primitive.class, body);
                berOut = new ByteArrayInputStream(asn1Primitive.getEncoded());
            } else if (body instanceof byte[]) {
                berOut = new ByteArrayInputStream(ObjectHelper.cast(byte[].class, body));
            }
        } else {
            byte[] byteInput = exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, graph);
            berOut = new ByteArrayInputStream(byteInput);
        }
        try {
            if (berOut != null) {
                IOHelper.copy(berOut, stream);
            }
        }
        catch (Throwable throwable) {
            IOHelper.close(berOut, stream);
            throw throwable;
        }
        IOHelper.close(berOut, stream);
    }

    private void encodeGenericTypeObject(Exchange exchange, OutputStream stream) throws Exception {
        Class[] paramOut = new Class[]{OutputStream.class};
        try (ReverseByteArrayOutputStream berOut = new ReverseByteArrayOutputStream(64, true);){
            Method encodeMethod = exchange.getIn().getBody().getClass().getDeclaredMethod("encode", paramOut);
            encodeMethod.invoke(exchange.getIn().getBody(), berOut);
            stream.write(berOut.getArray());
        }
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] asn1Bytes;
        if (this.usingIterator) {
            if (this.unmarshalType != null) {
                return new ASN1GenericIterator(this.unmarshalType, stream);
            }
            return new ASN1MessageIterator(exchange, stream);
        }
        try (ASN1InputStream ais = new ASN1InputStream(stream);
             ByteArrayOutputStream asn1Out = new ByteArrayOutputStream();){
            while (ais.available() > 0) {
                ASN1Primitive asn1Record = ais.readObject();
                asn1Out.write(asn1Record.getEncoded());
            }
            asn1Bytes = asn1Out.toByteArray();
        }
        return asn1Bytes;
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }
}

