/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.asn1;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1MessageIterator
implements Iterator<Message>,
Closeable {
    static final Logger LOGGER = LoggerFactory.getLogger(ASN1MessageIterator.class);
    private final Exchange exchange;
    private volatile ASN1InputStream asn1InputStream;
    private volatile Message parent;

    public ASN1MessageIterator(Exchange exchange, InputStream inputStream) {
        this.exchange = exchange;
        this.asn1InputStream = inputStream instanceof ASN1InputStream ? (ASN1InputStream)inputStream : new ASN1InputStream(inputStream);
        this.parent = null;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.asn1InputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.asn1InputStream.available() > 0;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                if (this.parent == null) {
                    this.asn1InputStream.close();
                    availableDataInCurrentEntry = false;
                } else {
                    availableDataInCurrentEntry = true;
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException(exception);
        }
    }

    private Message getNextElement() {
        if (this.asn1InputStream == null) {
            return null;
        }
        try {
            ASN1Primitive current = this.getNextEntry();
            if (current != null) {
                DefaultMessage answer = new DefaultMessage(this.exchange.getContext());
                answer.getHeaders().putAll(this.exchange.getIn().getHeaders());
                answer.setBody(current.getEncoded());
                return answer;
            }
            LOGGER.trace("close asn1InputStream");
            return null;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException(exception);
        }
    }

    private ASN1Primitive getNextEntry() throws IOException {
        return this.asn1InputStream.readObject();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Message next() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        Message answer = this.parent;
        this.parent = null;
        this.checkNullAnswer(answer);
        return answer;
    }

    private void checkNullAnswer(Message answer) {
        if (answer == null && this.asn1InputStream != null) {
            IOHelper.close((Closeable)this.asn1InputStream);
            this.asn1InputStream = null;
        }
    }

    @Override
    public void close() throws IOException {
        IOHelper.close((Closeable)this.asn1InputStream);
        this.asn1InputStream = null;
    }
}

