/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.scan;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;

public class PackageScanHelper {
    private PackageScanHelper() {
    }

    public static void registerBeans(CamelContext camelContext, Set<String> packages) {
        Registry registry;
        if (packages != null && !packages.isEmpty() && (registry = camelContext.getRegistry()) != null) {
            PackageScanClassResolver scanner = camelContext.getCamelContextExtension().getContextPlugin(PackageScanClassResolver.class);
            Injector injector = camelContext.getInjector();
            if (scanner != null && injector != null) {
                HashMap created = new HashMap();
                for (String pkg : packages) {
                    Class c;
                    Set<Class<?>> classes = scanner.findAnnotated(BindToRegistry.class, pkg);
                    for (Class<?> clazz : classes) {
                        Object b = injector.newInstance(clazz, false);
                        if (b == null) continue;
                        created.put(clazz, b);
                    }
                    for (Map.Entry entry : created.entrySet()) {
                        c = (Class)entry.getKey();
                        BindToRegistry ann = c.getAnnotation(BindToRegistry.class);
                        if (ann == null) continue;
                        String name = ann.value();
                        if (ObjectHelper.isEmpty(name)) {
                            name = c.getSimpleName();
                        }
                        Object bean = entry.getValue();
                        String beanName = c.getName();
                        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(camelContext).createBindToRegistryFactory(name, bean, beanName, false);
                        task.run();
                    }
                    for (Map.Entry entry : created.entrySet()) {
                        c = (Class)entry.getKey();
                        Object bean = entry.getValue();
                        String beanName = c.getName();
                        try {
                            PluginHelper.getBeanPostProcessor(camelContext).postProcessBeforeInitialization(bean, beanName);
                            PluginHelper.getBeanPostProcessor(camelContext).postProcessAfterInitialization(bean, beanName);
                        }
                        catch (Exception e) {
                            throw new RuntimeCamelException("Error post-processing bean: " + beanName, e);
                        }
                    }
                }
            }
        }
    }
}

