/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.fastagi.reply.AgiReply;

public class AgiReplyImpl
implements AgiReply {
    private static final Pattern STATUS_PATTERN = Pattern.compile("^(\\d{3})[ -]");
    private static final Pattern RESULT_PATTERN = Pattern.compile("^200 result=(\\S+)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("^200 result=\\S* +\\((.*)\\)");
    private static final Pattern ADDITIONAL_ATTRIBUTES_PATTERN = Pattern.compile("^200 result=\\S* +(\\(.*\\) )?(.+)$");
    private static final Pattern SYNOPSIS_PATTERN = Pattern.compile("^\\s*Usage:\\s*(.*)\\s*$");
    private static final String END_OF_PROPER_USAGE = "520 End of proper usage.";
    private static final long serialVersionUID = 3256727294671337012L;
    private List<String> lines;
    private String firstLine;
    private String result;
    private Integer status = null;
    private Map<String, String> attributes;
    private String extra;
    private String synopsis;
    private String usage;
    private boolean extraCreated;

    AgiReplyImpl() {
    }

    AgiReplyImpl(List<String> lines) {
        this();
        if (lines != null) {
            this.lines = new ArrayList<String>(lines);
            if (!lines.isEmpty()) {
                this.firstLine = lines.get(0);
            }
        }
    }

    @Override
    public String getFirstLine() {
        return this.firstLine;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public int getResultCode() {
        String result = this.getResult();
        if (result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public char getResultCodeAsChar() {
        int resultCode = this.getResultCode();
        if (resultCode < 0) {
            return '\u0000';
        }
        return (char)resultCode;
    }

    @Override
    public String getResult() {
        if (this.result != null) {
            return this.result;
        }
        Matcher matcher = RESULT_PATTERN.matcher(this.firstLine);
        this.result = matcher.find() ? matcher.group(1) : "";
        return this.result;
    }

    @Override
    public int getStatus() {
        if (this.status != null) {
            return this.status;
        }
        if (this.firstLine == null) {
            return -1;
        }
        Matcher matcher = STATUS_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.status = Integer.parseInt(matcher.group(1));
            return this.status;
        }
        return -1;
    }

    @Override
    public String getAttribute(String name) {
        if (this.getStatus() != 200) {
            return null;
        }
        if ("result".equalsIgnoreCase(name)) {
            return this.getResult();
        }
        return this.getAttributes().get(name.toLowerCase(Locale.ENGLISH));
    }

    protected Map<String, String> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        this.attributes = new HashMap<String, String>();
        Matcher matcher = ADDITIONAL_ATTRIBUTES_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.attributes.putAll(this.parseAttributes(matcher.group(2)));
        }
        return this.attributes;
    }

    Map<String, String> parseAttributes(String s2) {
        StringBuilder keyBuilder = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean inKey = true;
        boolean inQuotes = false;
        char previousChar = '\u0000';
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '=' && inKey) {
                inKey = false;
                inQuotes = false;
            } else if (c == ' ' && !inKey && !inQuotes) {
                map.put(keyBuilder.toString().toLowerCase(Locale.ENGLISH), valueBuilder.toString());
                keyBuilder.delete(0, keyBuilder.length());
                valueBuilder.delete(0, valueBuilder.length());
                inKey = true;
            } else if (c == '\"' && !inKey) {
                if (previousChar == '\\') {
                    valueBuilder.deleteCharAt(valueBuilder.length() - 1);
                    valueBuilder.append(c);
                } else {
                    inQuotes = !inQuotes;
                }
            } else if (inKey) {
                keyBuilder.append(c);
            } else {
                valueBuilder.append(c);
            }
            previousChar = c;
        }
        if (keyBuilder.length() > 0) {
            map.put(keyBuilder.toString().toLowerCase(Locale.ENGLISH), valueBuilder.toString());
        }
        return map;
    }

    @Override
    public String getExtra() {
        if (this.getStatus() != 200) {
            return null;
        }
        if (this.extraCreated) {
            return this.extra;
        }
        Matcher matcher = PARENTHESIS_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.extra = matcher.group(1);
        }
        this.extraCreated = true;
        return this.extra;
    }

    @Override
    public String getSynopsis() {
        String secondLine;
        Matcher synopsisMatcher;
        if (this.getStatus() != 520) {
            return null;
        }
        if (this.synopsis == null && this.lines.size() > 1 && (synopsisMatcher = SYNOPSIS_PATTERN.matcher(secondLine = this.lines.get(1))).find()) {
            this.synopsis = synopsisMatcher.group(1);
        }
        return this.synopsis;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            String line;
            StringBuilder usageSB = new StringBuilder();
            for (int i = 2; i < this.lines.size() && !END_OF_PROPER_USAGE.equals(line = this.lines.get(i)); ++i) {
                usageSB.append(line.trim());
                usageSB.append(" ");
            }
            this.usage = usageSB.toString().trim();
        }
        return this.usage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgiReply[");
        sb.append("status=").append(this.getStatus()).append(",");
        if (this.status == 200) {
            sb.append("result='").append(this.getResult()).append("',");
            sb.append("extra='").append(this.getExtra()).append("',");
            sb.append("attributes=").append(this.getAttributes()).append(",");
        }
        if (this.status == 520) {
            sb.append("synopsis='").append(this.getSynopsis()).append("',");
        }
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

