/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.lock;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.asteriskjava.lock.Locker;

public class Lockable {
    private final ReentrantLock internalLock = new ReentrantLock(false);
    private final String lockName;
    final AtomicReference<Thread> threadHoldingLock = new AtomicReference();
    private final AtomicInteger totalWaitTime = new AtomicInteger();
    private final AtomicInteger totalHoldTime = new AtomicInteger();
    private final AtomicInteger requested = new AtomicInteger();
    private final AtomicInteger waited = new AtomicInteger();
    private final AtomicInteger acquired = new AtomicInteger();
    private volatile boolean dumped = false;
    private volatile boolean blocked = false;
    private final RateLimiter rateLimiter = RateLimiter.create(4.0);
    private static final AtomicLong seed = new AtomicLong();
    private final long lockableId = seed.incrementAndGet();

    public Lockable() {
        this.lockName = this.getLockCaller();
    }

    private String getLockCaller() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        String name = this.getClass().getCanonicalName();
        for (StackTraceElement element : trace) {
            if (element.getFileName() == null || element.getFileName().contains(Lockable.class.getSimpleName())) continue;
            name = element.getFileName() + " " + element.getMethodName() + " " + element.getLineNumber() + " " + element.getClassName();
            break;
        }
        return name;
    }

    String asLockString() {
        return "Lockable [waited=" + this.waited + ", waitTime=" + this.totalWaitTime + ", totalHoldTime=" + this.totalHoldTime + ", acquired=" + this.acquired + ", object=" + this.lockName + ", id=" + this.lockableId + "]";
    }

    long getLockAverageHoldTime() {
        long hold = this.totalHoldTime.get();
        long count = this.acquired.get();
        if (count < 10L) {
            return 250L;
        }
        return Math.max(hold / count, 50L);
    }

    public Locker.LockCloser withLock() {
        return Locker.doWithLock(this);
    }

    ReentrantLock getInternalLock() {
        return this.internalLock;
    }

    void addLockTotalWaitTime(int time) {
        this.totalWaitTime.addAndGet(time);
    }

    void addLockTotalHoldTime(int time) {
        this.totalHoldTime.addAndGet(time);
    }

    int addLockRequested() {
        return this.requested.incrementAndGet();
    }

    void addLockWaited(int time) {
        this.waited.addAndGet(time);
    }

    void addLockAcquired(int count) {
        this.acquired.addAndGet(count);
    }

    boolean isLockDumped() {
        return this.dumped;
    }

    void setLockDumped(boolean dumped) {
        this.dumped = dumped;
    }

    int getLockTotalWaitTime() {
        return this.totalWaitTime.intValue();
    }

    int getLockWaited() {
        return this.waited.intValue();
    }

    int getLockRequested() {
        return this.requested.intValue();
    }

    Long getLockableId() {
        return this.lockableId;
    }

    int getLockTotalHoldTime() {
        return this.totalHoldTime.intValue();
    }

    int getLockAcquired() {
        return this.acquired.intValue();
    }

    boolean wasLockBlocked() {
        return this.blocked;
    }

    void setLockBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public RateLimiter getDumpRateLimit() {
        return this.rateLimiter;
    }
}

