/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.asterisk;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.CommandAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.ConfbridgeListAction;
import org.asteriskjava.pbx.asterisk.wrap.events.AbstractMeetMeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ConfbridgeListEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MeetMeJoinEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MeetMeLeaveEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvents;
import org.asteriskjava.pbx.asterisk.wrap.response.CommandResponse;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.asterisk.MeetmeRoom;
import org.asteriskjava.pbx.internal.asterisk.NoMeetmeException;
import org.asteriskjava.pbx.internal.asterisk.RoomOwner;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.CoherentManagerEventListener;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class MeetmeRoomControl
extends EventListenerBaseClass
implements CoherentManagerEventListener {
    private static final Log logger = LogFactory.getLog(MeetmeRoomControl.class);
    private Integer meetmeBaseAddress;
    private MeetmeRoom[] rooms;
    private int roomCount;
    private boolean meetmeInstalled = false;
    private static final AtomicReference<MeetmeRoomControl> self = new AtomicReference();

    public static synchronized void init(PBX pbx, int roomCount) throws NoMeetmeException {
        if (self.get() != null) {
            logger.warn("The MeetmeRoomControl has already been initialised.");
        } else {
            self.set(new MeetmeRoomControl(pbx, roomCount));
        }
    }

    public static MeetmeRoomControl getInstance() {
        if (self.get() == null) {
            throw new IllegalStateException("The MeetmeRoomControl has not been initialised. Please call MeetmeRoomControl.init().");
        }
        return self.get();
    }

    private MeetmeRoomControl(PBX pbx, int roomCount) throws NoMeetmeException {
        super("MeetmeRoomControl", pbx);
        this.roomCount = roomCount;
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        this.meetmeBaseAddress = settings.getMeetmeBaseAddress();
        this.rooms = new MeetmeRoom[roomCount];
        this.configure((AsteriskPBX)pbx);
        this.startListener();
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(MeetMeJoinEvent.class);
        required.add(MeetMeLeaveEvent.class);
        return required;
    }

    public MeetmeRoom findAvailableRoom(RoomOwner newOwner) {
        try (Locker.LockCloser closer = this.withLock();){
            int count = 0;
            for (MeetmeRoom room : this.rooms) {
                if (logger.isDebugEnabled()) {
                    logger.debug("room " + room.getRoomNumber() + " count " + count);
                }
                if (room.getOwner() == null || !room.getOwner().isRoomStillRequired()) {
                    try {
                        Long lastUpdated = room.getLastUpdated();
                        long now = System.currentTimeMillis();
                        if (lastUpdated != null) {
                            long elapsedTime = now - lastUpdated;
                            logger.error("room: " + room.getRoomNumber() + " count: " + count + " elapsed: " + elapsedTime);
                            if (elapsedTime > 1800000L && room.getChannelCount() < 2) {
                                logger.error("clearing room");
                                room.setInactive();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(e, e);
                    }
                    if (room.getChannelCount() == 0) {
                        room.setInactive();
                        room.setOwner(newOwner);
                        logger.info("Returning available room " + room.getRoomNumber());
                        MeetmeRoom meetmeRoom = room;
                        return meetmeRoom;
                    }
                } else {
                    logger.warn("Meetme " + room.getRoomNumber() + " is still in use by " + room.getOwner());
                }
                ++count;
            }
            logger.error("no more available rooms");
            MeetmeRoom[] meetmeRoomArray = null;
            return meetmeRoomArray;
        }
    }

    private MeetmeRoom findMeetmeRoom(String roomNumber) {
        try (Locker.LockCloser closer = this.withLock();){
            MeetmeRoom foundRoom = null;
            for (MeetmeRoom room : this.rooms) {
                if (room.getRoomNumber().compareToIgnoreCase(roomNumber) != 0) continue;
                foundRoom = room;
                break;
            }
            MeetmeRoom[] meetmeRoomArray = foundRoom;
            return meetmeRoomArray;
        }
    }

    MeetmeRoom getRoom(int room) {
        try (Locker.LockCloser closer = this.withLock();){
            MeetmeRoom meetmeRoom = this.rooms[room];
            return meetmeRoom;
        }
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        Channel channel;
        MeetmeRoom room;
        AbstractMeetMeEvent evt;
        if (event instanceof MeetMeJoinEvent) {
            evt = (MeetMeJoinEvent)event;
            room = this.findMeetmeRoom(evt.getMeetMe());
            channel = evt.getChannel();
            if (room != null && room.addChannel(channel)) {
                logger.debug(channel + " has joined the conference " + room.getRoomNumber() + " channelCount " + room.getChannelCount());
                room.setLastUpdated();
            }
        }
        if (event instanceof MeetMeLeaveEvent) {
            evt = (MeetMeLeaveEvent)event;
            room = this.findMeetmeRoom(evt.getMeetMe());
            channel = evt.getChannel();
            if (room != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(channel + " has left the conference " + room.getRoomNumber() + " channel count " + room.getChannelCount());
                }
                room.removeChannel(channel);
                room.setLastUpdated();
                if (room.getChannelCount() < 2 && room.getForceClose()) {
                    this.hangupChannels(room);
                    room.setInactive();
                }
                if (room.getChannelCount() < 1) {
                    room.setInactive();
                }
            }
        }
    }

    public void hangupChannels(MeetmeRoom room) {
        Channel[] Channels2 = room.getChannels();
        if (room.isActive()) {
            PBX pbx = PBXFactory.getActivePBX();
            for (Channel channel : Channels2) {
                room.removeChannel(channel);
                try {
                    logger.warn("Hanging up");
                    pbx.hangup(channel);
                }
                catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                    logger.error(e, e);
                }
            }
        }
    }

    private void configure(AsteriskPBX pbx) throws NoMeetmeException {
        int base = this.meetmeBaseAddress;
        for (int r = 0; r < this.roomCount; ++r) {
            this.rooms[r] = new MeetmeRoom(r + base);
        }
        try {
            if (pbx.getVersion().isAtLeast(AsteriskVersion.ASTERISK_13)) {
                String command = "ConfBridge list";
                ConfbridgeListAction action = new ConfbridgeListAction();
                ResponseEvents response = pbx.sendEventGeneratingAction(action, 3000);
                HashMap<String, Integer> roomChannelCount = new HashMap<String, Integer>();
                for (ResponseEvent responseEvent : response.getEvents()) {
                    ConfbridgeListEvent e = (ConfbridgeListEvent)responseEvent;
                    Integer current = (Integer)roomChannelCount.get(e.getConference());
                    if (current == null) {
                        roomChannelCount.put(e.getConference(), 1);
                        continue;
                    }
                    roomChannelCount.put(e.getConference(), current + 1);
                }
                for (Map.Entry entry : roomChannelCount.entrySet()) {
                    this.setRoomCount((String)entry.getKey(), (Integer)entry.getValue(), Integer.parseInt((String)entry.getKey()));
                }
                this.meetmeInstalled = true;
            } else {
                String command = pbx.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? "meetme list" : "meetme";
                CommandAction commandAction = new CommandAction(command);
                ManagerResponse response = pbx.sendAction(commandAction, 3000);
                if (!(response instanceof CommandResponse)) {
                    throw new ManagerCommunicationException(response.getMessage(), null);
                }
                CommandResponse commandResponse = (CommandResponse)response;
                logger.debug("parsing active meetme rooms");
                for (String string : commandResponse.getResult()) {
                    this.parseMeetme(string);
                    this.meetmeInstalled = true;
                    logger.debug(string);
                }
            }
        }
        catch (NoMeetmeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e, e);
            throw new NoMeetmeException(e.getLocalizedMessage());
        }
    }

    private void parseMeetme(String line) throws NoMeetmeException {
        try (Locker.LockCloser closer = this.withLock();){
            if (line != null) {
                if (line.toLowerCase().startsWith("no such command 'meetme'")) {
                    throw new NoMeetmeException("Asterisk is not configured correctly! Please enable the MeetMe app");
                }
                if (!(line.toLowerCase().startsWith("no active meetme conferences.") || line.toLowerCase().startsWith("conf num") || line.toLowerCase().startsWith("* total number") || line.toLowerCase().startsWith("no such conference") || line.toLowerCase().startsWith("no such command 'meetme"))) {
                    String roomNumber = line.substring(0, 10).trim();
                    String tmp = line.substring(11, 25).trim();
                    int channelCount = Integer.parseInt(tmp);
                    int roomNo = Integer.valueOf(roomNumber);
                    this.setRoomCount(roomNumber, channelCount, roomNo);
                }
            }
        }
    }

    private void setRoomCount(String roomNumber, int channelCount, int roomNo) {
        MeetmeRoom room;
        Integer base = this.meetmeBaseAddress;
        if (roomNo >= base && roomNo < base + this.roomCount && (room = this.findMeetmeRoom(roomNumber)) != null) {
            if (room.getChannelCount() != channelCount) {
                logger.warn("Room number: " + room.getRoomNumber() + " has a server side channel count = " + channelCount + " when the channel count for that room is: " + room.getChannelCount() + " the server side channel count will be reset.");
            }
            room.resetChannelCount(channelCount);
            room.setActive();
        }
    }

    public void stop() {
        this.close();
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    public boolean isMeetmeInstalled() {
        return this.meetmeInstalled;
    }
}

