/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.FileTrace;
import org.asteriskjava.util.internal.Trace;
import org.asteriskjava.util.internal.streamreader.FastScanner;
import org.asteriskjava.util.internal.streamreader.FastScannerFactory;

public class SocketConnectionFacadeImpl
implements SocketConnectionFacade {
    public static final Pattern CRNL_PATTERN = Pattern.compile("\r\n");
    public static final Pattern NL_PATTERN = Pattern.compile("\n");
    private Socket socket;
    private FastScanner scanner;
    private BufferedWriter writer;
    private Trace trace;
    public static final int MAX_SOCKET_READ_TIMEOUT_MILLIS = 10800000;

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout) throws IOException {
        this(host, port, ssl, timeout, readTimeout, StandardCharsets.UTF_8, CRNL_PATTERN);
    }

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout, Charset encoding) throws IOException {
        this(host, port, ssl, timeout, readTimeout, encoding, CRNL_PATTERN);
    }

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout, Pattern lineDelimiter) throws IOException {
        this(host, port, ssl, timeout, readTimeout, StandardCharsets.UTF_8, lineDelimiter);
    }

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout, Charset encoding, Pattern lineDelimiter) throws IOException {
        Socket socket = ssl ? SSLSocketFactory.getDefault().createSocket() : SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(readTimeout);
        socket.connect(new InetSocketAddress(host, port), timeout);
        this.initialize(socket, encoding, lineDelimiter);
        if (System.getProperty("org.asteriskjava.trace", "false").equalsIgnoreCase("true")) {
            this.trace = new FileTrace(socket);
        }
    }

    SocketConnectionFacadeImpl(Socket socket) throws IOException {
        this(socket, 10800000);
    }

    SocketConnectionFacadeImpl(Socket socket, int timeout) throws IOException {
        if (timeout == -1) {
            timeout = 0;
        } else if (timeout == 0) {
            timeout = 10800000;
        }
        socket.setSoTimeout(timeout);
        this.initialize(socket, StandardCharsets.UTF_8, NL_PATTERN);
    }

    private void initialize(Socket socket, Charset encoding, Pattern pattern) throws IOException {
        this.socket = socket;
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        InputStreamReader reader = new InputStreamReader(inputStream, encoding);
        this.scanner = FastScannerFactory.getReader(reader, pattern);
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
    }

    @Override
    public String readLine() throws IOException {
        String line = null;
        try {
            line = this.scanner.next();
        }
        catch (IllegalStateException e) {
            throw new IOException("No more lines available: " + e.getMessage());
        }
        catch (NoSuchElementException e) {
            throw new IOException("No more lines available: " + e.getMessage());
        }
        if (this.trace != null) {
            this.trace.received(line);
        }
        return line;
    }

    @Override
    public void write(String s2) throws IOException {
        this.writer.write(s2);
        if (this.trace != null) {
            this.trace.sent(s2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
        this.scanner.close();
        if (this.trace != null) {
            this.trace.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getPort();
    }
}

