/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asteriskjava.config.ConfigElement;

public class Category
extends ConfigElement {
    private String name;
    private boolean template;
    private final List<Category> baseCategories = new ArrayList<Category>();
    private final List<ConfigElement> elements = new ArrayList<ConfigElement>();

    public Category(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.name = name;
    }

    public Category(String filename, int lineno, String name) {
        super(filename, lineno);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemplate() {
        return this.template;
    }

    void markAsTemplate() {
        this.template = true;
    }

    public List<Category> getBaseCategories() {
        return this.baseCategories;
    }

    void addBaseCategory(Category baseCategory) {
        this.baseCategories.add(baseCategory);
    }

    public List<ConfigElement> getElements() {
        return this.elements;
    }

    public void addElement(ConfigElement element) {
        if (element instanceof Category) {
            throw new IllegalArgumentException("Nested categories are not allowed");
        }
        this.elements.add(element);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        this.format(sb);
        for (ConfigElement e : this.elements) {
            sb.append("\n");
            e.format(sb);
        }
        return sb.toString();
    }

    @Override
    protected StringBuilder rawFormat(StringBuilder sb) {
        sb.append("[").append(this.name).append("]");
        if (this.isTemplate() || !this.getBaseCategories().isEmpty()) {
            sb.append("(");
            if (this.isTemplate()) {
                sb.append("!");
                if (!this.getBaseCategories().isEmpty()) {
                    sb.append(",");
                }
            }
            Iterator<Category> inheritsFromIterator = this.getBaseCategories().iterator();
            while (inheritsFromIterator.hasNext()) {
                sb.append(inheritsFromIterator.next().getName());
                if (!inheritsFromIterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb;
    }

    public String toString() {
        return this.name;
    }
}

