/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.Activity;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class CompletionAdaptor<T extends Activity>
implements ActivityCallback<T> {
    private static final Log logger = LogFactory.getLog(CompletionAdaptor.class);
    CountDownLatch _latch = new CountDownLatch(1);

    @Override
    public void progress(T activity, ActivityStatusEnum status, String message) {
        if (status == ActivityStatusEnum.FAILURE || status == ActivityStatusEnum.SUCCESS) {
            this._latch.countDown();
        }
    }

    public void waitForCompletion(long timeout, TimeUnit unit) {
        try {
            if (!this._latch.await(timeout, unit)) {
                Exception e = new Exception("Timeout waiting for activity to complete (" + timeout + " " + (Object)((Object)unit) + ")");
                logger.error(e, e);
            }
        }
        catch (InterruptedException e) {
            logger.error(e, e);
        }
    }
}

