/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class DelegateSyncProcessor
extends ServiceSupport
implements DelegateProcessor,
AsyncProcessor,
Navigate<Processor> {
    protected final Processor processor;

    public DelegateSyncProcessor(Processor processor) {
        this.processor = processor;
    }

    public String toString() {
        return "DelegateSync[" + this.processor + "]";
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processor.process(exchange);
        }
        catch (Exception | LinkageError e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }
}

