/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.NewExtensionListener;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.SipPeersAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.StatusAction;
import org.asteriskjava.pbx.asterisk.wrap.events.DndStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MasqueradeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.PeerEntryEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.PeerStatusEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.PeerlistCompleteEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusCompleteEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.Peer;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class PeerMonitor
extends EventListenerBaseClass
implements Runnable {
    private static final Log logger = LogFactory.getLog(PeerMonitor.class);
    LockableList<Peer> peerList = new LockableList(new LinkedList());
    boolean initSip = false;
    private final Thread markAndSweepThread;
    private static PeerMonitor self;
    private static NewExtensionListener listener;

    public static synchronized void init(NewExtensionListener _listener) {
        listener = _listener;
        if (self == null) {
            self = new PeerMonitor();
        } else if (_listener != null) {
            logger.error("Call to PeerMonitor.init, but it's already initialized. Listener will not be set");
        }
    }

    public static synchronized PeerMonitor getInstance() {
        if (self == null) {
            throw new IllegalStateException("You must call PeerMonitor.init()");
        }
        return self;
    }

    private PeerMonitor() {
        super("PeerMonitor", PBXFactory.getActivePBX());
        this.startListener();
        this.addSipsToMonitor();
        try {
            if (listener != null) {
                listener.newExtension();
            } else {
                logger.warn("Peer monitor listener is null");
            }
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        this.markAndSweepThread = new Thread(this);
        this.markAndSweepThread.setName("PeerMonitor-MarkAndSweep");
        this.markAndSweepThread.setDaemon(true);
        this.markAndSweepThread.start();
    }

    public void addSipsToMonitor() {
        this.initSip = false;
        StatusAction sa = new StatusAction();
        SipPeersAction t2 = new SipPeersAction();
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            pbx.sendAction(t2, 5000);
            pbx.sendAction(sa, 5000);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }

    public Peer registerPeer(Channel newChannel) {
        Peer peer = this.registerPeer(newChannel.getEndPoint());
        return peer;
    }

    public Peer registerPeer(EndPoint endPoint) {
        if (endPoint.isLocal()) {
            return null;
        }
        try (Locker.LockCloser closer = this.peerList.withLock();){
            Peer peer = this.findPeer(endPoint);
            if (peer == null) {
                peer = new Peer(endPoint);
                this.peerList.add(peer);
            }
            Peer peer2 = peer;
            return peer2;
        }
    }

    public Peer findPeer(EndPoint peerEndPoint) {
        Peer found = null;
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                if (!peer.getEndPoint().isSame(peerEndPoint)) continue;
                found = peer;
                break;
            }
        }
        return found;
    }

    public Iterator<Peer> getIterator() {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            LinkedList<Peer> clone = new LinkedList<Peer>(this.peerList);
            Iterator<Peer> iterator = clone.iterator();
            return iterator;
        }
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(NewChannelEvent.class);
        required.add(PeerStatusEvent.class);
        required.add(PeerEntryEvent.class);
        required.add(PeerlistCompleteEvent.class);
        required.add(NewStateEvent.class);
        required.add(StatusEvent.class);
        required.add(StatusCompleteEvent.class);
        required.add(DndStateEvent.class);
        return required;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof PeerStatusEvent) {
            this.handleEvent((PeerStatusEvent)event);
        } else if (event instanceof PeerlistCompleteEvent) {
            this.handleEvent((PeerlistCompleteEvent)event);
        } else if (event instanceof PeerEntryEvent) {
            this.handleEvent((PeerEntryEvent)event);
        } else if (event instanceof NewChannelEvent) {
            this.handleEvent((NewChannelEvent)event);
        } else if (event instanceof MasqueradeEvent) {
            this.handleEvent((MasqueradeEvent)event);
        } else if (event instanceof StatusEvent) {
            this.handleEvent((StatusEvent)event);
        } else if (event instanceof StatusCompleteEvent) {
            this.handleEvent((StatusCompleteEvent)event);
        } else if (event instanceof NewStateEvent) {
            this.handleEvent((NewStateEvent)event);
        }
    }

    private void handleEvent(NewStateEvent event) {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.handleEvent(event);
            }
        }
    }

    private void handleEvent(NewChannelEvent event) {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.handleEvent(event);
            }
        }
    }

    private void handleEvent(MasqueradeEvent event) {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.handleEvent(event);
            }
        }
    }

    private void handleEvent(StatusEvent event) {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.handleEvent(event);
            }
        }
    }

    private void handleEvent(PeerEntryEvent event) {
        EndPoint endPoint = event.getPeer();
        this.registerPeer(endPoint);
    }

    private void handleEvent(PeerlistCompleteEvent b) {
        this.initSip = true;
    }

    private void handleEvent(PeerStatusEvent event) {
        this.registerPeer(event.getPeer());
    }

    private void handleEvent(StatusCompleteEvent event) {
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.endSweep();
            }
        }
        logger.debug("Channel Mark and Sweep complete");
    }

    boolean isInitialized() {
        return this.initSip;
    }

    public void stop() {
        this.close();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(120000L);
                    PeerMonitor.getInstance().startSweep();
                }
            }
            catch (InterruptedException e) {
                logger.error(e, e);
                continue;
            }
            break;
        }
    }

    public void startSweep() {
        logger.debug("Starting channel mark and sweep");
        try (Locker.LockCloser closer = this.peerList.withLock();){
            for (Peer peer : this.peerList) {
                peer.startSweep();
            }
        }
        StatusAction sa = new StatusAction();
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            pbx.sendAction(sa, 5000);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.HIGH;
    }
}

