/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FakeHttpSession
implements HttpSession {
    private final long creationTime;
    private final ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
    private final String sessionId;
    private final ServletContext servletContext;
    private int maxInactiveInterval;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public FakeHttpSession(String sessionId, ServletContext servletContext, long creationTime, int maxInactiveInterval) {
        this.sessionId = sessionId;
        this.servletContext = servletContext;
        this.creationTime = creationTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public FakeHttpSession(HttpSession session) {
        this(session.getId(), session.getServletContext(), session.getLastAccessedTime(), session.getMaxInactiveInterval());
        this.copyAttributes(session);
    }

    public void destroy() {
        this.attributes.clear();
    }

    @Override
    public long getCreationTime() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return this.creationTime;
    }

    @Override
    public String getId() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return this.sessionId;
    }

    @Override
    public long getLastAccessedTime() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return 0L;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return this.attributes.keys();
    }

    public String[] getValueNames() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return (String[])Collections.list(this.attributes.keys()).toArray();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        this.attributes.remove(name);
    }

    public FakeHttpSession copyAttributes(HttpSession httpSession) {
        Enumeration<String> e = httpSession.getAttributeNames();
        while (e.hasMoreElements()) {
            Object o;
            String k = e.nextElement();
            if (k == null || (o = httpSession.getAttribute(k)) == null) continue;
            this.attributes.put(k, o);
        }
        return this;
    }

    @Override
    public void invalidate() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        this.valid.set(false);
    }

    @Override
    public boolean isNew() {
        if (!this.valid.get()) {
            throw new IllegalStateException();
        }
        return false;
    }
}

