/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.RssReader;
import java.io.IOException;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.AtomUtils;
import org.apache.camel.component.feed.FeedEntryPollingConsumer;

public class AtomEntryPollingConsumer
extends FeedEntryPollingConsumer {
    private RssReader rssReader;
    private List<Item> items;

    public AtomEntryPollingConsumer(AtomEndpoint endpoint, Processor processor, boolean throttleEntries) {
        super(endpoint, processor, throttleEntries);
    }

    @Override
    protected void doStart() throws Exception {
        this.rssReader = new RssReader();
        this.rssReader.addItemExtension("name", Item::setAuthor);
        super.doStart();
    }

    @Override
    protected void populateList(Object feed) throws IOException {
    }

    @Override
    protected Object createFeed() throws IOException {
        return this.readItems();
    }

    @Override
    protected void resetList() {
        this.items = null;
    }

    private List<Item> readItems() throws IOException {
        if (this.items == null) {
            this.list = this.items = AtomUtils.readItems(this.endpoint.getCamelContext(), this.endpoint.getFeedUri(), this.rssReader, this.endpoint.isSortEntries());
            this.entryIndex = this.list.size() - 1;
        }
        return this.items;
    }
}

