/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.RssReader;
import com.apptasticsoftware.rssreader.util.ItemComparator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public final class AtomUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Item> readItems(CamelContext camelContext, String uri, RssReader reader, boolean sort) throws IOException {
        if (ResourceHelper.isHttpUri(uri)) {
            return reader.read(uri).sorted(sort ? ItemComparator.oldestItemFirst() : Comparator.naturalOrder()).collect(Collectors.toList());
        }
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, uri);
        try {
            List<Item> list = reader.read(is).sorted(sort ? ItemComparator.oldestItemFirst() : Comparator.naturalOrder()).collect(Collectors.toList());
            return list;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }
}

