/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.RestClientRequestValidator;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.http.RestUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.Jsoner;

public class DefaultRestClientRequestValidator
implements RestClientRequestValidator {
    @Override
    public RestClientRequestValidator.ValidationError validate(Exchange exchange, RestClientRequestValidator.ValidationContext validationContext) {
        String json;
        String contentType = ExchangeHelper.getContentType(exchange);
        if (!RestUtil.isValidOrAcceptedContentType(validationContext.consumes(), contentType)) {
            return new RestClientRequestValidator.ValidationError(415, null);
        }
        String accept = exchange.getMessage().getHeader("Accept", String.class);
        if (!RestUtil.isValidOrAcceptedContentType(validationContext.produces(), accept)) {
            return new RestClientRequestValidator.ValidationError(406, null);
        }
        if (validationContext.requiredQueryParameters() != null && !exchange.getIn().getHeaders().keySet().containsAll(validationContext.requiredQueryParameters())) {
            return new RestClientRequestValidator.ValidationError(400, "Some of the required query parameters are missing.");
        }
        if (validationContext.requiredHeaders() != null && !exchange.getIn().getHeaders().keySet().containsAll(validationContext.requiredHeaders())) {
            return new RestClientRequestValidator.ValidationError(400, "Some of the required HTTP headers are missing.");
        }
        if (validationContext.queryAllowedValues() != null) {
            for (Map.Entry<String, String> e : validationContext.queryAllowedValues().entrySet()) {
                String k = e.getKey();
                Object v = exchange.getMessage().getHeader(k);
                if (v == null) continue;
                String[] parts = e.getValue().split(",");
                if (!Arrays.stream(parts).noneMatch(v::equals)) continue;
                return new RestClientRequestValidator.ValidationError(400, "Some of the query parameters or HTTP headers has a not-allowed value.");
            }
        }
        Object body = exchange.getMessage().getBody();
        if (validationContext.requiredBody()) {
            body = MessageHelper.extractBodyAsString(exchange.getIn());
            if (ObjectHelper.isNotEmpty(body)) {
                exchange.getIn().setBody(body);
            }
            if (ObjectHelper.isEmpty(body)) {
                return new RestClientRequestValidator.ValidationError(400, "The request body is missing.");
            }
        }
        if (body != null && contentType != null && RestUtil.isValidOrAcceptedContentType("application/json", contentType) && !ObjectHelper.isEmpty(json = MessageHelper.extractBodyAsString(exchange.getIn()))) {
            try {
                Jsoner.deserialize(json);
            }
            catch (DeserializationException e) {
                return new RestClientRequestValidator.ValidationError(400, "Invalid JSon payload.");
            }
        }
        return null;
    }
}

