/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AvroEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AvroEndpoint target = (AvroEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(AvroEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(AvroEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(AvroEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(AvroEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "protocol": {
                target.getConfiguration().setProtocol(AvroEndpointConfigurer.property(camelContext, Protocol.class, value));
                return true;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                target.getConfiguration().setProtocolClassName(AvroEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "protocollocation": 
            case "protocolLocation": {
                target.getConfiguration().setProtocolLocation(AvroEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                target.getConfiguration().setReflectionProtocol(AvroEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "singleparameter": 
            case "singleParameter": {
                target.getConfiguration().setSingleParameter(AvroEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "uriauthority": 
            case "uriAuthority": {
                target.getConfiguration().setUriAuthority(AvroEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "protocol": {
                return Protocol.class;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return String.class;
            }
            case "protocollocation": 
            case "protocolLocation": {
                return String.class;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return Boolean.TYPE;
            }
            case "singleparameter": 
            case "singleParameter": {
                return Boolean.TYPE;
            }
            case "uriauthority": 
            case "uriAuthority": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AvroEndpoint target = (AvroEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "protocol": {
                return target.getConfiguration().getProtocol();
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return target.getConfiguration().getProtocolClassName();
            }
            case "protocollocation": 
            case "protocolLocation": {
                return target.getConfiguration().getProtocolLocation();
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return target.getConfiguration().isReflectionProtocol();
            }
            case "singleparameter": 
            case "singleParameter": {
                return target.getConfiguration().isSingleParameter();
            }
            case "uriauthority": 
            case "uriAuthority": {
                return target.getConfiguration().getUriAuthority();
            }
        }
        return null;
    }
}

