/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.options;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.share.models.FileLastWrittenMode;
import com.azure.storage.file.share.models.ShareRequestConditions;

public final class ShareFileSeekableByteChannelWriteOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileSeekableByteChannelWriteOptions.class);
    private final boolean overwriteMode;
    private Long fileSize;
    private ShareRequestConditions requestConditions;
    private FileLastWrittenMode fileLastWrittenMode;
    private Long chunkSizeInBytes;

    public ShareFileSeekableByteChannelWriteOptions(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public Long getFileSizeInBytes() {
        return this.fileSize;
    }

    public ShareFileSeekableByteChannelWriteOptions setFileSize(Long fileSize) {
        if (!this.overwriteMode) {
            throw LOGGER.logExceptionAsError(new UnsupportedOperationException("Cannot set 'fileSize' unless creating a new file."));
        }
        if (fileSize != null && fileSize < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'fileSize' must be a non-negative number if provided."));
        }
        this.fileSize = fileSize;
        return this;
    }

    public Long getChunkSizeInBytes() {
        return this.chunkSizeInBytes;
    }

    public ShareFileSeekableByteChannelWriteOptions setChunkSizeInBytes(Long chunkSizeInBytes) {
        this.chunkSizeInBytes = chunkSizeInBytes;
        return this;
    }

    public ShareRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ShareFileSeekableByteChannelWriteOptions setRequestConditions(ShareRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public FileLastWrittenMode getFileLastWrittenMode() {
        return this.fileLastWrittenMode;
    }

    public ShareFileSeekableByteChannelWriteOptions setFileLastWrittenMode(FileLastWrittenMode fileLastWrittenMode) {
        this.fileLastWrittenMode = fileLastWrittenMode;
        return this;
    }
}

