/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.catalog.LanguageValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.impl.CatalogHelper;
import org.apache.camel.catalog.impl.TimePatternConverter;
import org.apache.camel.tooling.model.ApiMethodModel;
import org.apache.camel.tooling.model.ApiModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.DevConsoleModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.PojoBeanModel;
import org.apache.camel.tooling.model.TransformerModel;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class AbstractCamelCatalog {
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("([\\w.]+)");
    private static final Pattern ENV_OR_SYS_PATTERN = Pattern.compile("\\{\\{(env|sys):\\w+\\}\\}");
    private static final Pattern SYNTAX_DASH_PATTERN = Pattern.compile("([\\w.-]+)");
    private static final Pattern COMPONENT_SYNTAX_PARSER = Pattern.compile("([^\\w-]*)([\\w-]+)");
    private SuggestionStrategy suggestionStrategy;
    private JSonSchemaResolver jsonSchemaResolver;

    public String componentJSonSchema(String name) {
        return this.jsonSchemaResolver.getComponentJSonSchema(name);
    }

    public String modelJSonSchema(String name) {
        return this.getJSonSchemaResolver().getModelJSonSchema(name);
    }

    public EipModel eipModel(String name) {
        String json = this.modelJSonSchema(name);
        return json != null ? JsonMapper.generateEipModel(json) : null;
    }

    public ComponentModel componentModel(String name) {
        String json = this.componentJSonSchema(name);
        return json != null ? JsonMapper.generateComponentModel(json) : null;
    }

    public String dataFormatJSonSchema(String name) {
        return this.getJSonSchemaResolver().getDataFormatJSonSchema(name);
    }

    public DataFormatModel dataFormatModel(String name) {
        String json = this.dataFormatJSonSchema(name);
        return json != null ? JsonMapper.generateDataFormatModel(json) : null;
    }

    public String languageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        return this.getJSonSchemaResolver().getLanguageJSonSchema(name);
    }

    public LanguageModel languageModel(String name) {
        String json = this.languageJSonSchema(name);
        return json != null ? JsonMapper.generateLanguageModel(json) : null;
    }

    public String transformerJSonSchema(String name) {
        return this.getJSonSchemaResolver().getTransformerJSonSchema(name);
    }

    public TransformerModel transformerModel(String name) {
        String json = this.transformerJSonSchema(name);
        return json != null ? JsonMapper.generateTransformerModel(json) : null;
    }

    public PojoBeanModel pojoBeanModel(String name) {
        String json = this.pojoBeanJSonSchema(name);
        return json != null ? JsonMapper.generatePojoBeanModel(json) : null;
    }

    public String pojoBeanJSonSchema(String name) {
        return this.getJSonSchemaResolver().getPojoBeanJSonSchema(name);
    }

    public String devConsoleJSonSchema(String name) {
        return this.getJSonSchemaResolver().getDevConsoleJSonSchema(name);
    }

    public DevConsoleModel devConsoleModel(String name) {
        String json = this.devConsoleJSonSchema(name);
        return json != null ? JsonMapper.generateDevConsoleModel(json) : null;
    }

    public String otherJSonSchema(String name) {
        return this.getJSonSchemaResolver().getOtherJSonSchema(name);
    }

    public OtherModel otherModel(String name) {
        String json = this.otherJSonSchema(name);
        return json != null ? JsonMapper.generateOtherModel(json) : null;
    }

    public String mainJSonSchema() {
        return this.getJSonSchemaResolver().getMainJsonSchema();
    }

    public MainModel mainModel() {
        String json = this.mainJSonSchema();
        return json != null ? JsonMapper.generateMainModel(json) : null;
    }

    public SuggestionStrategy getSuggestionStrategy() {
        return this.suggestionStrategy;
    }

    public void setSuggestionStrategy(SuggestionStrategy suggestionStrategy) {
        this.suggestionStrategy = suggestionStrategy;
    }

    public JSonSchemaResolver getJSonSchemaResolver() {
        return this.jsonSchemaResolver;
    }

    public void setJSonSchemaResolver(JSonSchemaResolver resolver) {
        this.jsonSchemaResolver = resolver;
    }

    public boolean validateTimePattern(String pattern) {
        return AbstractCamelCatalog.validateDuration(pattern);
    }

    public EndpointValidationResult validateEndpointProperties(String uri) {
        return this.validateEndpointProperties(uri, false, false, false);
    }

    public EndpointValidationResult validateEndpointProperties(String uri, boolean ignoreLenientProperties) {
        return this.validateEndpointProperties(uri, ignoreLenientProperties, false, false);
    }

    public EndpointValidationResult validateProperties(String scheme, Map<String, String> properties) {
        boolean lenient = Boolean.getBoolean(properties.getOrDefault("lenient", "false"));
        return this.validateProperties(scheme, properties, lenient, false, false);
    }

    private EndpointValidationResult validateProperties(String scheme, Map<String, String> properties, boolean lenient, boolean consumerOnly, boolean producerOnly) {
        DataFormatModel dataFormatModel;
        Object dfName;
        String key2;
        String[] apiSyntax;
        EndpointValidationResult result = new EndpointValidationResult(scheme);
        ComponentModel model = this.componentModel(scheme);
        HashMap<String, BaseOptionModel> rows = new HashMap<String, BaseOptionModel>();
        model.getComponentOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        model.getEndpointOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        model.getEndpointPathOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        if (model.isApi()) {
            apiSyntax = StringHelper.splitWords(model.getApiSyntax());
            String string = properties.get(apiSyntax[0]);
            key2 = apiSyntax.length > 1 ? properties.get(apiSyntax[1]) : null;
            Map<String, BaseOptionModel> apiProperties = this.extractApiProperties(model, string, key2);
            rows.putAll(apiProperties);
        }
        if ("dataformat".equals(scheme) && (dfName = properties.get("name")) != null && (dataFormatModel = this.dataFormatModel((String)dfName)) != null) {
            dataFormatModel.getOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        }
        for (Map.Entry entry : properties.entrySet()) {
            boolean valid;
            boolean bool;
            boolean deprecated;
            BaseOptionModel row;
            String value = (String)entry.getValue();
            String originalName = (String)entry.getKey();
            String name = AbstractCamelCatalog.stripOptionalPrefixFromName(rows, originalName);
            String propertyName = AbstractCamelCatalog.getPropertyNameFromNameWithPrefix(rows, name);
            if (propertyName != null) {
                name = propertyName;
            }
            if ((row = (BaseOptionModel)rows.get(name)) == null) {
                String[] suggestions;
                boolean namePlaceholder = name.startsWith("{{") && name.endsWith("}}");
                if (namePlaceholder || "stub".equals(scheme)) continue;
                if (lenient) {
                    result.addLenient(name);
                    continue;
                }
                result.addUnknown(name);
                if (this.suggestionStrategy == null || (suggestions = this.suggestionStrategy.suggestEndpointOptions(rows.keySet(), name)) == null) continue;
                result.addUnknownSuggestions(name, suggestions);
                continue;
            }
            if ("parameter".equals(row.getKind())) {
                String label = row.getLabel();
                if (consumerOnly) {
                    if (label != null && label.contains("producer")) {
                        result.addNotConsumerOnly(name);
                    }
                } else if (producerOnly && label != null && label.contains("consumer")) {
                    result.addNotProducerOnly(name);
                }
            }
            String prefix = row.getPrefix();
            boolean valuePlaceholder = value.startsWith("{{") || value.startsWith("${") || value.startsWith("$simple{");
            boolean lookup = value.startsWith("#") && value.length() > 1;
            boolean multiValue = prefix != null && originalName.startsWith(prefix) && row.isMultiValue();
            Object defaultValue = row.getDefaultValue();
            if (defaultValue != null) {
                result.addDefaultValue(name, defaultValue.toString());
            }
            if (row.isRequired() && CatalogHelper.isEmpty(value)) {
                result.addRequired(name);
            }
            if (deprecated = row.isDeprecated()) {
                result.addDeprecated(name);
            }
            List<String> enums = row.getEnums();
            if (!(multiValue || valuePlaceholder || lookup || enums == null)) {
                boolean found = false;
                for (String s : enums) {
                    String dashEC = StringHelper.camelCaseToDash(value);
                    String valueEC = StringHelper.asEnumConstantValue(value);
                    if (!value.equalsIgnoreCase(s) && !dashEC.equalsIgnoreCase(s) && !valueEC.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.handleNotFound(result, value, name, enums);
                }
            }
            if (!(multiValue || enums != null || "path".equals(row.getKind()) || !"object".equals(row.getType()) || value.startsWith("#") && value.length() > 1)) {
                result.addInvalidReference(name, value);
            }
            if (!(multiValue || valuePlaceholder || lookup || !"boolean".equals(row.getType()) || (bool = ObjectHelper.isBoolean(value)))) {
                result.addInvalidBoolean(name, value);
            }
            if (!(multiValue || valuePlaceholder || lookup || !"duration".equals(row.getType()) || (valid = AbstractCamelCatalog.validateDuration(value)))) {
                result.addInvalidDuration(name, value);
            }
            if (!(multiValue || valuePlaceholder || lookup || !"integer".equals(row.getType()) || (valid = AbstractCamelCatalog.validateInteger(value)))) {
                result.addInvalidInteger(name, value);
            }
            if (multiValue || valuePlaceholder || lookup || !"number".equals(row.getType())) continue;
            valid = false;
            try {
                valid = !Double.valueOf(value).isNaN() || !Float.valueOf(value).isNaN();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (valid) continue;
            result.addInvalidNumber(name, value);
        }
        if (model.isApi()) {
            apiSyntax = StringHelper.splitWords(model.getApiSyntax());
            String string = properties.get(apiSyntax[0]);
            String string2 = key2 = apiSyntax.length > 1 ? properties.get(apiSyntax[1]) : null;
            if (string != null && key2 != null) {
                ApiModel api = model.getApiOptions().stream().filter(o -> o.getName().equalsIgnoreCase(key1)).findFirst().orElse(null);
                if (api == null) {
                    result.addInvalidEnum(apiSyntax[0], string);
                    result.addInvalidEnumChoices(apiSyntax[0], (String[])model.getApiOptions().stream().map(ApiModel::getName).toArray(String[]::new));
                } else {
                    boolean found = false;
                    for (ApiMethodModel m2 : api.getMethods()) {
                        String key3 = AbstractCamelCatalog.apiMethodAlias(api, m2);
                        if (!m2.getName().equalsIgnoreCase(key2) && !key2.equalsIgnoreCase(key3)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        result.addInvalidEnum(apiSyntax[1], key2);
                        result.addInvalidEnumChoices(apiSyntax[1], (String[])api.getMethods().stream().map(m -> {
                            String answer = AbstractCamelCatalog.apiMethodAlias(api, m);
                            if (answer == null) {
                                answer = m.getName();
                            }
                            return answer;
                        }).toArray(String[]::new));
                    }
                }
            }
        }
        for (BaseOptionModel baseOptionModel : rows.values()) {
            if (!baseOptionModel.isRequired()) continue;
            String name = baseOptionModel.getName();
            Object value = properties.get(name);
            if (CatalogHelper.isEmpty(value)) {
                value = baseOptionModel.getDefaultValue();
            }
            if (!CatalogHelper.isEmpty(value)) continue;
            result.addRequired(name);
        }
        return result;
    }

    private void handleNotFound(EndpointValidationResult result, String value, String name, List<String> enums) {
        LinkedHashSet<String> names;
        String[] suggestions;
        result.addInvalidEnum(name, value);
        result.addInvalidEnumChoices(name, enums.toArray(new String[0]));
        if (this.suggestionStrategy != null && (suggestions = this.suggestionStrategy.suggestEndpointOptions(names = new LinkedHashSet<String>(enums), value)) != null) {
            result.addInvalidEnumSuggestions(name, suggestions);
        }
    }

    private void handleNotFound(ConfigurationPropertiesValidationResult result, String value, String longKey, List<String> enums) {
        LinkedHashSet<String> names;
        String[] suggestions;
        result.addInvalidEnum(longKey, value);
        result.addInvalidEnumChoices(longKey, enums.toArray(new String[0]));
        if (this.suggestionStrategy != null && (suggestions = this.suggestionStrategy.suggestEndpointOptions(names = new LinkedHashSet<String>(enums), value)) != null) {
            result.addInvalidEnumSuggestions(longKey, suggestions);
        }
    }

    public EndpointValidationResult validateEndpointProperties(String uri, boolean ignoreLenientProperties, boolean consumerOnly, boolean producerOnly) {
        try {
            ComponentModel model;
            URI u = URISupport.normalizeUriAsURI(uri);
            String scheme = u.getScheme();
            ComponentModel componentModel = model = scheme != null ? this.componentModel(scheme) : null;
            if (model == null) {
                EndpointValidationResult result = new EndpointValidationResult(uri);
                if (uri.startsWith("{{")) {
                    result.addIncapable(uri);
                } else if (scheme != null) {
                    result.addUnknownComponent(scheme);
                } else {
                    result.addUnknownComponent(uri);
                }
                return result;
            }
            Map<String, String> properties = this.endpointProperties(uri);
            boolean lenient = !model.isConsumerOnly() && !model.isProducerOnly() && consumerOnly ? false : !ignoreLenientProperties && model.isLenientProperties();
            return this.validateProperties(scheme, properties, lenient, consumerOnly, producerOnly);
        }
        catch (URISyntaxException e) {
            EndpointValidationResult result = new EndpointValidationResult(uri);
            result.addSyntaxError(e.getMessage());
            return result;
        }
    }

    public Map<String, String> endpointProperties(String uri) throws URISyntaxException {
        Object value;
        Object key;
        String[] apiSyntax;
        int pos;
        URI u = URISupport.normalizeUriAsURI(uri);
        String scheme = u.getScheme();
        ComponentModel model = this.componentModel(scheme);
        if (model == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = model.getSyntax();
        String alternativeSyntax = model.getAlternativeSyntax();
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        LinkedHashMap<String, String> userInfoOptions = new LinkedHashMap<String, String>();
        if (alternativeSyntax != null && alternativeSyntax.contains("@")) {
            alternativeSyntax = StringHelper.after(alternativeSyntax, ":");
            int idx = alternativeSyntax.indexOf(64);
            String fields = alternativeSyntax.substring(0, idx);
            String[] names = fields.split(":");
            String authority = u.getAuthority();
            if (authority != null && authority.contains("@")) {
                String password;
                String username;
                String userInfo = authority.substring(0, authority.indexOf(64));
                String[] parts = userInfo.split(":");
                if (parts.length == 2) {
                    username = parts[0];
                    password = parts[1];
                } else {
                    username = userInfo;
                    password = null;
                }
                if (names.length == 2) {
                    userInfoOptions.put(names[0], username);
                    if (password != null) {
                        userInfoOptions.put(names[1], password);
                    }
                }
            }
        }
        syntax = StringHelper.after(syntax, ":");
        uri = StringHelper.after(uri, ":");
        String uriPath = URISupport.stripQuery(uri);
        Matcher matcher = ENV_OR_SYS_PATTERN.matcher(uriPath);
        uriPath = matcher.replaceAll("");
        if (!userInfoOptions.isEmpty()) {
            uriPath = StringHelper.after(uriPath, "@", uriPath);
        }
        if (uriPath != null && uriPath.startsWith("//")) {
            uriPath = uriPath.substring(2);
        }
        matcher = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (scheme.equals(s)) continue;
            word.add(s);
        }
        List<String> word2 = AbstractCamelCatalog.findTokens(syntax, scheme, uriPath);
        boolean defaultValueAdded = false;
        LinkedHashMap<Object, String> options = new LinkedHashMap<Object, String>();
        if (!userInfoOptions.isEmpty()) {
            options.putAll(userInfoOptions);
        }
        HashMap<String, BaseOptionModel> rows = new HashMap<String, BaseOptionModel>();
        model.getComponentOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        model.getEndpointOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        model.getEndpointPathOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
        if (model.isApi() && (pos = word.indexOf((apiSyntax = StringHelper.splitWords(model.getSyntax()))[0])) != -1) {
            key = word2.size() > pos ? word2.get(pos) : null;
            Map<String, BaseOptionModel> map = this.extractApiProperties(model, (String)key, null);
            rows.putAll(map);
        }
        Iterator<String> it = word2.iterator();
        for (int i = 0; i < word.size(); ++i) {
            boolean allOptions;
            key = (String)word.get(i);
            BaseOptionModel baseOptionModel = (BaseOptionModel)rows.get(key);
            boolean bl = allOptions = word.size() == word2.size();
            if (allOptions) {
                value = it.next();
                options.put(key, (String)value);
                continue;
            }
            if (!baseOptionModel.isRequired()) {
                boolean last;
                value = null;
                boolean bl2 = last = i == word.size() - 1;
                if (last) {
                    Object object = value = it.hasNext() ? it.next() : null;
                    if (value != null) {
                        options.put(key, value.toString());
                    } else {
                        value = baseOptionModel.getDefaultValue();
                    }
                }
                if (value == null) continue;
                options.put(key, value.toString());
                defaultValueAdded = true;
                continue;
            }
            Object object = value = it.hasNext() ? it.next() : null;
            if (value == null) continue;
            options.put(key, (String)value);
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry entry : options.entrySet()) {
            String key2 = (String)entry.getKey();
            value = (String)entry.getValue();
            BaseOptionModel row = (BaseOptionModel)rows.get(key2);
            if (defaultValueAdded) {
                boolean required = row.isRequired();
                Object defaultValue = row.getDefaultValue();
                if (!required && defaultValue != null && defaultValue.toString().equals(value)) continue;
            }
            answer.put(key2, (String)value);
        }
        Map<String, Object> parameters = CatalogHelper.parseParameters(u);
        while (!parameters.isEmpty()) {
            Map<String, Object> values;
            String csb;
            String prefix;
            Map.Entry<String, Object> entry = parameters.entrySet().iterator().next();
            String key3 = entry.getKey();
            value = entry.getValue() != null ? entry.getValue().toString() : "";
            BaseOptionModel row = (BaseOptionModel)rows.get(key3);
            if (row != null && row.isMultiValue() && (prefix = row.getPrefix()) != null && !(csb = (values = URISupport.extractProperties(parameters, prefix)).entrySet().stream().map(multi -> prefix + (String)multi.getKey() + "=" + (multi.getValue() != null ? multi.getValue().toString() : "")).collect(Collectors.joining("&"))).isEmpty()) {
                value = (String)value + "&" + csb;
            }
            answer.put(key3, (String)value);
            parameters.remove(key3);
        }
        return answer;
    }

    private static List<String> findTokens(String syntax, String scheme, String uriPath) {
        String[] tokens = SYNTAX_PATTERN.split(syntax);
        ArrayList<String> word2 = new ArrayList<String>();
        int prev = 0;
        int prevPath = 0;
        if (("activemq".equals(scheme) || "jms".equals(scheme)) && uriPath.startsWith("temp:")) {
            prevPath = 5;
        }
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            int idx = -1;
            int len = 0;
            if (":".equals(token)) {
                idx = uriPath.indexOf("://", prevPath);
                len = 3;
            }
            if (idx == -1) {
                idx = uriPath.indexOf(token, prevPath);
                len = token.length();
            }
            if (idx <= 0) continue;
            String option = uriPath.substring(prev, idx);
            word2.add(option);
            prevPath = prev = idx + len;
        }
        if (prev > 0 || word2.isEmpty()) {
            String option = uriPath.substring(prev);
            word2.add(option);
        }
        return word2;
    }

    private Map<String, BaseOptionModel> extractApiProperties(ComponentModel model, String key, String key2) {
        LinkedHashMap<String, BaseOptionModel> answer = new LinkedHashMap<String, BaseOptionModel>();
        if (key != null) {
            Object matchKey = null;
            String dashKey = StringHelper.camelCaseToDash(key);
            String ecKey = StringHelper.asEnumConstantValue(key);
            String dashKey2 = StringHelper.camelCaseToDash(key2);
            String ecKey2 = StringHelper.asEnumConstantValue(key2);
            for (ApiModel am : model.getApiOptions()) {
                String aKey = am.getName();
                if (!aKey.equalsIgnoreCase("DEFAULT") && !aKey.equalsIgnoreCase(key) && !aKey.equalsIgnoreCase(ecKey) && !aKey.equalsIgnoreCase(dashKey)) continue;
                am.getMethods().stream().filter(m -> {
                    if (key2 == null) {
                        return true;
                    }
                    String name = m.getName();
                    if (name.equalsIgnoreCase(key2) || name.equalsIgnoreCase(ecKey2) || name.equalsIgnoreCase(dashKey2)) {
                        return true;
                    }
                    String key3 = AbstractCamelCatalog.apiMethodAlias(am, m);
                    if (key3 != null) {
                        String dashKey3 = StringHelper.camelCaseToDash(key3);
                        String ecKey3 = StringHelper.asEnumConstantValue(key3);
                        if (key2.equalsIgnoreCase(key3) || ecKey2.equalsIgnoreCase(ecKey3) || dashKey2.equalsIgnoreCase(dashKey3)) {
                            return true;
                        }
                    }
                    return false;
                }).forEach(m -> m.getOptions().forEach(o -> answer.put(o.getName(), (BaseOptionModel)o)));
            }
        }
        return answer;
    }

    private static String apiMethodAlias(ApiModel api, ApiMethodModel method) {
        String name = method.getName();
        for (String alias : api.getAliases()) {
            int pos = alias.indexOf(61);
            String pattern = alias.substring(0, pos);
            String aliasMethod = alias.substring(pos + 1);
            if (!Pattern.compile(pattern, 2).matcher(name).matches()) continue;
            return aliasMethod;
        }
        return null;
    }

    public Map<String, String> endpointLenientProperties(String uri) throws URISyntaxException {
        URI u = URISupport.normalizeUriAsURI(uri);
        String scheme = u.getScheme();
        ComponentModel model = this.componentModel(scheme);
        if (model == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        HashMap rows = new HashMap();
        model.getComponentOptions().forEach(o -> rows.put(o.getName(), o));
        model.getEndpointOptions().forEach(o -> rows.put(o.getName(), o));
        model.getEndpointPathOptions().forEach(o -> rows.put(o.getName(), o));
        Map<String, Object> parameters = URISupport.parseParameters(u);
        Set names = rows.keySet();
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        parameters.forEach((key, v) -> {
            String value = v != null ? v.toString() : "";
            int dot = key.indexOf(46);
            if (dot != -1) {
                String prefix = key.substring(0, dot + 1);
                String option = AbstractCamelCatalog.getPropertyNameFromNameWithPrefix(rows, prefix);
                if (option == null || !((BaseOptionModel)rows.get(option)).isMultiValue()) {
                    answer.put((String)key, value);
                }
            } else if (!names.contains(key)) {
                answer.put((String)key, value);
            }
        });
        return answer;
    }

    public String endpointComponentName(String uri) {
        if (uri != null) {
            return StringHelper.before(uri, ":");
        }
        return null;
    }

    public String asEndpointUri(String scheme, Map<String, String> properties, boolean encode) {
        return this.doAsEndpointUri(scheme, properties, "&", encode);
    }

    public String asEndpointUriXml(String scheme, Map<String, String> properties, boolean encode) {
        return this.doAsEndpointUri(scheme, properties, "&amp;", encode);
    }

    String doAsEndpointUri(String scheme, Map<String, String> properties, String ampersand, boolean encode) {
        String remainder;
        boolean queryOnly;
        ComponentModel model = this.componentModel(scheme);
        if (model == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String originalSyntax = model.getSyntax();
        if (originalSyntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        properties = this.filterProperties(scheme, properties);
        HashMap rows = new HashMap();
        model.getComponentOptions().forEach(o -> rows.put(o.getName(), o));
        model.getEndpointOptions().forEach(o -> rows.put(o.getName(), o));
        model.getEndpointPathOptions().forEach(o -> rows.put(o.getName(), o));
        if (originalSyntax.contains(":")) {
            originalSyntax = StringHelper.after(originalSyntax, ":");
        }
        TreeMap<String, String> copy = new TreeMap<String, String>(properties);
        Matcher syntaxMatcher = COMPONENT_SYNTAX_PARSER.matcher(originalSyntax);
        StringBuilder sb = new StringBuilder();
        while (syntaxMatcher.find()) {
            sb.append(syntaxMatcher.group(1));
            String propertyName = syntaxMatcher.group(2);
            String propertyValue = (String)copy.remove(propertyName);
            sb.append(propertyValue != null ? propertyValue : propertyName);
        }
        String syntax = sb.toString();
        String[] keys = AbstractCamelCatalog.syntaxKeys(originalSyntax);
        boolean hasAllKeys = properties.keySet().containsAll(Arrays.asList(keys));
        sb = new StringBuilder();
        if (hasAllKeys) {
            sb.append(syntax);
            if (!copy.isEmpty()) {
                copy.replaceAll((key, val) -> AbstractCamelCatalog.wrapRAW(key, val, rows));
                boolean hasQuestionMark = sb.toString().contains("?");
                sb.append(hasQuestionMark ? ampersand : Character.valueOf('?'));
                String query = URISupport.createQueryString(copy, ampersand, encode);
                sb.append(query);
            }
        } else {
            String[] tokens = SYNTAX_DASH_PATTERN.split(syntax);
            Matcher matcher = SYNTAX_PATTERN.matcher(originalSyntax);
            ArrayList<String> options = new ArrayList<String>();
            while (matcher.find()) {
                String s = matcher.group(1);
                options.add(s);
            }
            syntax = syntax.replace("{{", "BEGINCAMELPLACEHOLDER");
            syntax = syntax.replace("}}", "ENDCAMELPLACEHOLDER");
            Matcher matcher2 = SYNTAX_DASH_PATTERN.matcher(syntax);
            ArrayList<String> options2 = new ArrayList<String>();
            while (matcher2.find()) {
                String s = matcher2.group(1);
                s = s.replace("BEGINCAMELPLACEHOLDER", "{{");
                s = s.replace("ENDCAMELPLACEHOLDER", "}}");
                options2.add(s);
            }
            int range = 0;
            boolean first = true;
            boolean hasQuestionmark = false;
            for (int i = 0; i < options.size(); ++i) {
                Object value;
                BaseOptionModel row;
                boolean contains;
                String key2 = (String)options.get(i);
                String key22 = (String)options2.get(i);
                String token = null;
                if (tokens.length > i) {
                    token = tokens[i];
                }
                if (!(contains = properties.containsKey(key2)) && (row = (BaseOptionModel)rows.get(key2)) != null && row.isRequired() && !CatalogHelper.isEmpty(value = row.getDefaultValue())) {
                    key22 = value.toString();
                    properties.put(key2, key22);
                }
                if (properties.containsKey(key2)) {
                    if (!first && token != null) {
                        sb.append(token);
                    }
                    hasQuestionmark |= key2.contains("?") || token != null && token.contains("?");
                    sb.append(key22);
                    first = false;
                }
                ++range;
            }
            while (range < options2.size()) {
                String token = null;
                if (tokens.length > range) {
                    token = tokens[range];
                }
                String key2 = (String)options2.get(range);
                sb.append(token);
                sb.append(key2);
                hasQuestionmark |= key2.contains("?") || token != null && token.contains("?");
                ++range;
            }
            if (!copy.isEmpty()) {
                copy.replaceAll((key, val) -> AbstractCamelCatalog.wrapRAW(key, val, rows));
                sb.append(hasQuestionmark ? ampersand : Character.valueOf('?'));
                String query = URISupport.createQueryString(copy, ampersand, encode);
                sb.append(query);
            }
        }
        if (queryOnly = (remainder = sb.toString()).startsWith("?")) {
            return scheme + remainder;
        }
        if (!remainder.isEmpty()) {
            return scheme + ":" + remainder;
        }
        return scheme;
    }

    private static String wrapRAW(String key, String val, Map<String, BaseOptionModel> rows) {
        if (val == null) {
            return val;
        }
        BaseOptionModel option = rows.get(key);
        if (option == null) {
            return val;
        }
        if (option.isSecret() && !val.startsWith("#") && !val.startsWith("RAW(")) {
            return "RAW(" + val + ")";
        }
        return val;
    }

    private static String[] syntaxKeys(String syntax) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (syntax != null) {
            StringBuilder current = new StringBuilder();
            for (int i = 0; i < syntax.length(); ++i) {
                char ch = syntax.charAt(i);
                if (Character.isLetterOrDigit(ch)) {
                    current.append(ch);
                    continue;
                }
                if (current.length() <= 0) continue;
                tokens.add(current.toString());
                current = new StringBuilder();
            }
            if (!current.isEmpty()) {
                tokens.add(current.toString());
            }
        }
        return tokens.toArray(new String[0]);
    }

    public ConfigurationPropertiesValidationResult validateConfigurationProperty(String line) {
        String longKey;
        String key = longKey = StringHelper.before(line, "=");
        String value = StringHelper.after(line, "=");
        if (longKey != null) {
            longKey = longKey.trim();
        }
        if (key != null) {
            key = key.trim();
        }
        if (value != null) {
            value = value.trim();
        }
        ConfigurationPropertiesValidationResult result = new ConfigurationPropertiesValidationResult();
        boolean accept = AbstractCamelCatalog.acceptConfigurationPropertyKey(key);
        if (!accept) {
            result.setAccepted(false);
            return result;
        }
        result.setAccepted(true);
        key = key.substring("camel.".length());
        Function<String, BaseModel> loader = null;
        if (key.startsWith("component.")) {
            key = key.substring("component.".length());
            loader = this::componentModel;
        } else if (key.startsWith("dataformat.")) {
            key = key.substring("dataformat.".length());
            loader = this::dataFormatModel;
        } else if (key.startsWith("language.")) {
            key = key.substring("language.".length());
            loader = this::languageModel;
        }
        if (loader != null) {
            int idx = key.indexOf(46);
            String name = key.substring(0, idx);
            String option = key.substring(idx + 1);
            if (value != null) {
                BaseModel model = loader.apply(name);
                if (model == null) {
                    result.addUnknownComponent(name);
                    return result;
                }
                HashMap<String, BaseOptionModel> rows = new HashMap<String, BaseOptionModel>();
                model.getOptions().forEach(o -> rows.put(o.getName(), (BaseOptionModel)o));
                String nOption = option.replace("-", "").toLowerCase(Locale.ENGLISH);
                String suffix = null;
                int posDot = nOption.indexOf(46);
                int posBracket = nOption.indexOf(91);
                this.validateConfigurationProperty(posDot, posBracket, suffix, nOption, result, rows, name, value, longKey);
            }
        } else if (key.startsWith("main.") || key.startsWith("resilience4j.") || key.startsWith("faulttolerance.") || key.startsWith("threadpool.") || key.startsWith("lra.") || key.startsWith("health.") || key.startsWith("rest.")) {
            String name = StringHelper.before(key, ".");
            if (value != null) {
                MainModel model = this.mainModel();
                if (model == null) {
                    result.addIncapable("camel-main not detected on classpath");
                    return result;
                }
                HashMap<String, BaseOptionModel> rows = new HashMap<String, BaseOptionModel>();
                model.getOptions().forEach(o -> rows.put(AbstractCamelCatalog.dashToCamelCase(o.getName()), (BaseOptionModel)o));
                String nOption = longKey.replace("-", "").toLowerCase(Locale.ENGLISH);
                int secondDot = nOption.indexOf(46, nOption.indexOf(46) + 1) + 1;
                String suffix = null;
                int posDot = nOption.indexOf(46, secondDot);
                int posBracket = nOption.indexOf(91, secondDot);
                this.validateConfigurationProperty(posDot, posBracket, suffix, nOption, result, rows, name, value, longKey);
            }
        }
        return result;
    }

    private void validateConfigurationProperty(int posDot, int posBracket, String suffix, String nOption, ConfigurationPropertiesValidationResult result, Map<String, BaseOptionModel> rows, String name, String value, String longKey) {
        if (posDot > 0 && posBracket > 0) {
            int first = Math.min(posDot, posBracket);
            suffix = nOption.substring(first);
            nOption = nOption.substring(0, first);
        } else if (posDot > 0) {
            suffix = nOption.substring(posDot);
            nOption = nOption.substring(0, posDot);
        } else if (posBracket > 0) {
            suffix = nOption.substring(posBracket);
            nOption = nOption.substring(0, posBracket);
        }
        this.doValidateConfigurationProperty(result, rows, name, value, longKey, nOption, suffix);
    }

    private void doValidateConfigurationProperty(ConfigurationPropertiesValidationResult result, Map<String, BaseOptionModel> rows, String name, String value, String longKey, String lookupKey, String suffix) {
        String rowKey = rows.keySet().stream().filter(n -> n.toLowerCase(Locale.ENGLISH).equals(lookupKey)).findFirst().orElse(null);
        if (rowKey == null) {
            String[] suggestions;
            result.addUnknown(longKey);
            if (this.suggestionStrategy != null && (suggestions = this.suggestionStrategy.suggestEndpointOptions(rows.keySet(), name)) != null) {
                result.addUnknownSuggestions(name, suggestions);
            }
        } else {
            boolean valid;
            boolean bool;
            boolean optionPlaceholder = value.startsWith("{{") || value.startsWith("${") || value.startsWith("$simple{");
            boolean lookup = value.startsWith("#") && value.length() > 1;
            BaseOptionModel row = rows.get(rowKey);
            if (!optionPlaceholder && !lookup && row.isDeprecated()) {
                result.addDeprecated(longKey);
            }
            if (!optionPlaceholder && !lookup && "boolean".equals(row.getType()) && !(bool = ObjectHelper.isBoolean(value))) {
                result.addInvalidBoolean(longKey, value);
            }
            if (!optionPlaceholder && !lookup && "duration".equals(row.getType()) && !(valid = AbstractCamelCatalog.validateDuration(value))) {
                result.addInvalidDuration(longKey, value);
            }
            if (!optionPlaceholder && !lookup && "integer".equals(row.getType()) && !(valid = AbstractCamelCatalog.validateInteger(value))) {
                result.addInvalidInteger(longKey, value);
            }
            if (!optionPlaceholder && !lookup && "number".equals(row.getType())) {
                valid = false;
                try {
                    valid = !Double.valueOf(value).isNaN() || !Float.valueOf(value).isNaN();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!valid) {
                    result.addInvalidNumber(longKey, value);
                }
            }
            List<String> enums = row.getEnums();
            if (!optionPlaceholder && !lookup && enums != null) {
                boolean found = false;
                String dashEC = StringHelper.camelCaseToDash(value);
                String valueEC = StringHelper.asEnumConstantValue(value);
                for (String s : enums) {
                    if (!value.equalsIgnoreCase(s) && !dashEC.equalsIgnoreCase(s) && !valueEC.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.handleNotFound(result, value, longKey, enums);
                }
            }
            String javaType = row.getJavaType();
            if (!optionPlaceholder && !lookup && javaType != null && (javaType.startsWith("java.util.Map") || javaType.startsWith("java.util.Properties"))) {
                if (AbstractCamelCatalog.isValidSuffix(suffix)) {
                    result.addInvalidMap(longKey, value);
                } else if (suffix.startsWith("[") && !suffix.contains("]")) {
                    result.addInvalidMap(longKey, value);
                }
            }
            if (!optionPlaceholder && !lookup && javaType != null && "array".equals(row.getType())) {
                if (AbstractCamelCatalog.isValidSuffix(suffix)) {
                    result.addInvalidArray(longKey, value);
                } else if (!suffix.startsWith("[") && !suffix.contains("]")) {
                    result.addInvalidArray(longKey, value);
                } else {
                    String index = StringHelper.before(suffix.substring(1), "]");
                    boolean valid2 = AbstractCamelCatalog.validateInteger(index);
                    if (!valid2) {
                        result.addInvalidInteger(longKey, index);
                    }
                }
            }
        }
    }

    private static boolean isValidSuffix(String suffix) {
        return suffix == null || suffix.isEmpty() || suffix.equals(".");
    }

    private static boolean acceptConfigurationPropertyKey(String key) {
        if (key == null) {
            return false;
        }
        return key.startsWith("camel.component.") || key.startsWith("camel.dataformat.") || key.startsWith("camel.language.") || key.startsWith("camel.main.") || key.startsWith("camel.resilience4j.") || key.startsWith("camel.faulttolerance.") || key.startsWith("camel.threadpool.") || key.startsWith("camel.health.") || key.startsWith("camel.lra.") || key.startsWith("camel.rest.");
    }

    private LanguageValidationResult doValidateSimple(ClassLoader classLoader, String simple, boolean predicate) {
        Class<?> clazz;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String resolved = simple.replaceAll("\\{\\{(.+)\\}\\}", "~^$1^~");
        LanguageValidationResult answer = new LanguageValidationResult(simple);
        Object instance = null;
        try {
            clazz = classLoader.loadClass("org.apache.camel.impl.engine.SimpleCamelContext");
            Object context = clazz.getDeclaredConstructor(Boolean.TYPE).newInstance(false);
            clazz = classLoader.loadClass("org.apache.camel.language.simple.SimpleLanguage");
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            clazz = classLoader.loadClass("org.apache.camel.CamelContext");
            instance.getClass().getMethod("setCamelContext", clazz).invoke(instance, context);
        }
        catch (Exception e) {
            clazz = null;
            answer.setError(e.getMessage());
        }
        if (clazz != null) {
            Throwable cause = null;
            try {
                if (predicate) {
                    instance.getClass().getMethod("createPredicate", String.class).invoke(instance, resolved);
                } else {
                    instance.getClass().getMethod("createExpression", String.class).invoke(instance, resolved);
                }
            }
            catch (InvocationTargetException e) {
                cause = e.getTargetException();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                Object result;
                Method method2;
                String errMsg = cause.getMessage();
                errMsg = errMsg.replaceAll("\\~\\^(.+)\\^\\~", "{{$1}}");
                answer.setError(errMsg);
                if (cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleIllegalSyntaxException") || cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleParserException")) {
                    try {
                        method2 = cause.getClass().getMethod("getIndex", new Class[0]);
                        result = method2.invoke((Object)cause, new Object[0]);
                        if (result != null) {
                            int index = (Integer)result;
                            answer.setIndex(index);
                        }
                    }
                    catch (Exception method2) {
                        // empty catch block
                    }
                }
                if (cause.getClass().getName().equals("org.apache.camel.language.simple.types.SimpleIllegalSyntaxException")) {
                    String msg;
                    int idx;
                    try {
                        method2 = cause.getClass().getMethod("getShortMessage", new Class[0]);
                        result = method2.invoke((Object)cause, new Object[0]);
                        if (result != null) {
                            String msg2 = (String)result;
                            answer.setShortError(msg2);
                        }
                    }
                    catch (Exception method3) {
                        // empty catch block
                    }
                    if (answer.getShortError() == null && (idx = (msg = answer.getError()).indexOf(" at location ")) > 0) {
                        msg = msg.substring(0, idx);
                        answer.setShortError(msg);
                    }
                }
            }
        }
        return answer;
    }

    public LanguageValidationResult validateLanguagePredicate(ClassLoader classLoader, String language, String text) {
        if ("simple".equals(language)) {
            return this.doValidateSimple(classLoader, text, true);
        }
        return this.doValidateLanguage(classLoader, language, text, true);
    }

    public LanguageValidationResult validateLanguageExpression(ClassLoader classLoader, String language, String text) {
        if ("simple".equals(language)) {
            return this.doValidateSimple(classLoader, text, false);
        }
        return this.doValidateLanguage(classLoader, language, text, false);
    }

    private LanguageValidationResult doValidateLanguage(ClassLoader classLoader, String language, String text, boolean predicate) {
        LanguageModel model;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        LanguageValidationResult answer = new LanguageValidationResult(text);
        Map<String, Object> options = null;
        if (language.contains("?")) {
            String query = URISupport.extractQuery(language);
            language = StringHelper.before(language, "?");
            try {
                options = URISupport.parseQuery(query);
            }
            catch (Exception e) {
                answer.setError("Cannot parse language options: " + query);
                return answer;
            }
        }
        if ((model = this.languageModel(language)) == null) {
            answer.setError("Unknown language " + language);
            return answer;
        }
        String className = model.getJavaType();
        if (className == null) {
            answer.setError("Cannot find javaType for language " + language);
            return answer;
        }
        Object instance = null;
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(className);
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (options != null) {
            Map<String, Object> fOptions = options;
            Object fInstance = instance;
            ReflectionHelper.doWithFields(clazz, field -> {
                Object value = fOptions.get(field.getName());
                if (value != null) {
                    ReflectionHelper.setField(field, fInstance, value);
                }
            });
        }
        if (clazz != null && instance != null) {
            Throwable cause = null;
            try {
                try {
                    if (predicate) {
                        instance.getClass().getMethod("validatePredicate", String.class).invoke(instance, text);
                    } else {
                        instance.getClass().getMethod("validateExpression", String.class).invoke(instance, text);
                    }
                    return answer;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (predicate) {
                        instance.getClass().getMethod("createPredicate", String.class).invoke(instance, text);
                    } else {
                        instance.getClass().getMethod("createExpression", String.class).invoke(instance, text);
                    }
                }
            }
            catch (InvocationTargetException e) {
                cause = e.getTargetException();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                answer.setError(cause.getMessage());
            }
        }
        return answer;
    }

    private Map<String, String> filterProperties(String scheme, Map<String, String> options) {
        String showAll;
        if ("log".equals(scheme) && "true".equals(showAll = options.get("showAll"))) {
            LinkedHashMap<String, String> filtered = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                boolean skip = key.startsWith("show") && !key.equals("showAll");
                if (skip) continue;
                filtered.put(key, entry.getValue());
            }
            return filtered;
        }
        return options;
    }

    private static boolean validateInteger(String value) {
        boolean valid = false;
        try {
            Integer.parseInt(value);
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    private static boolean validateDuration(String value) {
        boolean valid = false;
        try {
            Long.parseLong(value);
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!valid) {
            try {
                if (value.startsWith("P") || value.startsWith("-P") || value.startsWith("p") || value.startsWith("-p")) {
                    Duration.parse(value);
                } else {
                    TimePatternConverter.toMilliSeconds(value);
                }
                valid = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }

    private static String stripOptionalPrefixFromName(Map<String, BaseOptionModel> rows, String name) {
        for (BaseOptionModel row : rows.values()) {
            String optionalPrefix = row.getOptionalPrefix();
            if (optionalPrefix != null && !optionalPrefix.isEmpty() && name.startsWith(optionalPrefix)) {
                return AbstractCamelCatalog.stripOptionalPrefixFromName(rows, name.substring(optionalPrefix.length()));
            }
            if (!name.equalsIgnoreCase(row.getName())) continue;
            break;
        }
        return name;
    }

    private static String getPropertyNameFromNameWithPrefix(Map<String, BaseOptionModel> rows, String name) {
        for (BaseOptionModel row : rows.values()) {
            String prefix = row.getPrefix();
            if (prefix == null || prefix.isEmpty() || !name.startsWith(prefix)) continue;
            return row.getName();
        }
        return null;
    }

    private static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        if (!StringHelper.isDashed(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '-') {
                sb.append(Character.toUpperCase(text.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

