/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import com.azure.storage.file.share.models.ShareFileItem;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.azure.FilesConfiguration;
import org.apache.camel.component.file.azure.FilesEndpoint;
import org.apache.camel.component.file.azure.FilesURIStrings;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.spi.annotations.Component;

@Component(value="azure-files")
public class FilesComponent
extends RemoteFileComponent<ShareFileItem> {
    public static final String SCHEME = "azure-files";

    public FilesComponent() {
    }

    public FilesComponent(CamelContext context) {
        super(context);
    }

    protected FilesEndpoint buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        FilesConfiguration config = new FilesConfiguration(FilesURIStrings.getBaseURI(uri));
        return new FilesEndpoint(uri, this, config);
    }

    @Override
    protected void afterPropertiesSet(GenericFileEndpoint<ShareFileItem> endpoint) throws Exception {
        if (endpoint.getFileExist() == GenericFileExist.Append) {
            throw new IllegalArgumentException("Appending to remote files is not supported.");
        }
        if (endpoint.getFileExist() == GenericFileExist.Move) {
            throw new IllegalArgumentException("Moving of existing remote files is not implemented.");
        }
    }
}

