/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

public final class FilesPath {
    public static final String PARENT = "..";
    public static final String CWD = ".";
    public static final String SHARE_ROOT = "/";
    public static final char PATH_SEPARATOR = '/';

    private FilesPath() {
    }

    public static boolean isEmpty(String path) {
        return path == null || path.isBlank();
    }

    public static boolean isEmptyStep(String path) {
        return FilesPath.isEmpty(path) || path.equals(CWD);
    }

    public static boolean isRoot(String path) {
        return path != null && path.equals(SHARE_ROOT);
    }

    public static boolean isAbsolute(String path) {
        return path != null && path.startsWith(SHARE_ROOT);
    }

    public static String ensureRelative(String path) {
        if (path.startsWith(SHARE_ROOT)) {
            return path.substring(1);
        }
        return path;
    }

    public static String concat(String dir, String subPath) {
        if (FilesPath.isEmptyStep(dir)) {
            return subPath;
        }
        if (FilesPath.isEmptyStep(subPath)) {
            return dir;
        }
        return FilesPath.hasTrailingSeparator(dir) ? dir + subPath : dir + SHARE_ROOT + subPath;
    }

    public static String trimTrailingSeparator(String path) {
        if (path == null) {
            return null;
        }
        if (FilesPath.hasTrailingSeparator(path)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean hasTrailingSeparator(String path) {
        return path.charAt(path.length() - 1) == '/';
    }

    public static String trimParentPath(String path) {
        if (path == null) {
            return null;
        }
        int lastSeparator = path.lastIndexOf(47);
        if (lastSeparator != -1) {
            return path.substring(lastSeparator + 1);
        }
        return path;
    }

    public static String extractParentPath(String path) {
        if (path == null) {
            return null;
        }
        int lastSeparator = path.lastIndexOf(47);
        if (lastSeparator == 0) {
            return SHARE_ROOT;
        }
        if (lastSeparator > 0) {
            return path.substring(0, lastSeparator);
        }
        return null;
    }

    public static String[] split(String path) {
        return FilesPath.splitToSteps(path, false);
    }

    public static String[] splitToSteps(String path, boolean preserveRootAsStep) {
        boolean includeRoot;
        if (path == null) {
            return null;
        }
        if (preserveRootAsStep && path.equals(SHARE_ROOT)) {
            return new String[]{SHARE_ROOT};
        }
        boolean bl = includeRoot = preserveRootAsStep && path.startsWith(SHARE_ROOT);
        if (!includeRoot) {
            path = FilesPath.ensureRelative(path);
        }
        String[] pathSteps = path.split(SHARE_ROOT);
        if (includeRoot) {
            pathSteps[0] = SHARE_ROOT;
        }
        return pathSteps;
    }

    public static String trimLeadingSeparator(String path) {
        if (path == null) {
            return null;
        }
        if (FilesPath.isAbsolute(path)) {
            return path.substring(1);
        }
        return path;
    }
}

