/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure.strategy;

import com.azure.storage.file.share.models.ShareFileItem;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategyFactory;
import org.apache.camel.component.file.azure.strategy.FilesChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.azure.strategy.StrategyUtil;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileNoOpProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.util.ObjectHelper;

public final class FilesProcessStrategyFactory
implements GenericFileProcessStrategyFactory<ShareFileItem> {
    @Override
    public GenericFileProcessStrategy<ShareFileItem> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            GenericFileExpressionRenamer renamer;
            GenericFileDeleteProcessStrategy<ShareFileItem> strategy = new GenericFileDeleteProcessStrategy<ShareFileItem>();
            strategy.setExclusiveReadLockStrategy(FilesProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        if (isMove || isNoop) {
            GenericFileExpressionRenamer renamer;
            GenericFileRenameProcessStrategy<ShareFileItem> strategy = new GenericFileRenameProcessStrategy<ShareFileItem>();
            strategy.setExclusiveReadLockStrategy(FilesProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (!isNoop && moveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveExpression);
                strategy.setCommitRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            return strategy;
        }
        GenericFileNoOpProcessStrategy<ShareFileItem> strategy = new GenericFileNoOpProcessStrategy<ShareFileItem>();
        strategy.setExclusiveReadLockStrategy(FilesProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<ShareFileItem> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy strategy = (GenericFileExclusiveReadLockStrategy)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("rename".equals(readLock)) {
                GenericFileRenameExclusiveReadLockStrategy<ShareFileItem> readLockStrategy = new GenericFileRenameExclusiveReadLockStrategy<ShareFileItem>();
                StrategyUtil.setup(readLockStrategy, params);
                return readLockStrategy;
            }
            if ("changed".equals(readLock)) {
                FilesChangedExclusiveReadLockStrategy readLockStrategy = new FilesChangedExclusiveReadLockStrategy();
                StrategyUtil.setup(readLockStrategy, params);
                return readLockStrategy;
            }
        }
        return null;
    }
}

