/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-files:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure Storage Files poll response details")
public class AzureFilesCloudEventDataTypeTransformer
extends Transformer {
    @Override
    public void transform(Message message, DataType fromType, DataType toType) {
        Map<String, Object> headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.storage.files.poll");
        if (message.getHeaders().containsKey("CamelFileHost")) {
            headers.put("CamelCloudEventSource", "azure.storage.files." + message.getHeader("CamelFileHost", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelFileName", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

