/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.SharedExecutorService;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.StorageFileInputStream;
import com.azure.storage.file.share.StorageFileOutputStream;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileReadBehavior;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileWriteBehavior;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListHeaders;
import com.azure.storage.file.share.implementation.models.FilesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesStartCopyHeaders;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.CopyableFileSmbPropertiesList;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.Range;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadOptions;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileCopyOptions;
import com.azure.storage.file.share.options.ShareFileDownloadOptions;
import com.azure.storage.file.share.options.ShareFileListRangesDiffOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelReadOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelWriteOptions;
import com.azure.storage.file.share.options.ShareFileUploadRangeFromUrlOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareFileClientBuilder.class)
public class ShareFileClient {
    private final ShareFileAsyncClient shareFileAsyncClient;
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String filePath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final String fileUrlString;

    ShareFileClient(ShareFileAsyncClient shareFileAsyncClient, AzureFileStorageImpl azureFileStorageClient, String shareName, String filePath, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        this.shareFileAsyncClient = shareFileAsyncClient;
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(filePath, "'filePath' cannot be null.");
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
        StringBuilder fileUrlstring = new StringBuilder(azureFileStorageClient.getUrl()).append("/").append(shareName).append("/").append(filePath);
        if (snapshot != null) {
            fileUrlstring.append("?sharesnapshot=").append(snapshot);
        }
        this.fileUrlString = fileUrlstring.toString();
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getFileUrl() {
        return this.fileUrlString;
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public final StorageFileInputStream openInputStream() {
        return this.openInputStream(new ShareFileRange(0L));
    }

    public final StorageFileInputStream openInputStream(ShareFileRange range) {
        return new StorageFileInputStream(this.shareFileAsyncClient, range.getStart(), range.getEnd() == null ? null : Long.valueOf(range.getEnd() - range.getStart() + 1L));
    }

    public final StorageFileOutputStream getFileOutputStream() {
        return this.getFileOutputStream(0L);
    }

    public final StorageFileOutputStream getFileOutputStream(long offset) {
        return new StorageFileOutputStream(this.shareFileAsyncClient, offset);
    }

    public SeekableByteChannel getFileSeekableByteChannelWrite(ShareFileSeekableByteChannelWriteOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (options.isOverwriteMode()) {
            Objects.requireNonNull(options.getFileSizeInBytes(), "'options.getFileSize()' cannot return null.");
            this.create(options.getFileSizeInBytes());
        }
        int chunkSize = options.getChunkSizeInBytes() != null ? options.getChunkSizeInBytes().intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, new StorageSeekableByteChannelShareFileWriteBehavior(this, options.getRequestConditions(), options.getFileLastWrittenMode()), 0L);
    }

    public SeekableByteChannel getFileSeekableByteChannelRead(ShareFileSeekableByteChannelReadOptions options) {
        ShareRequestConditions conditions = options != null ? options.getRequestConditions() : null;
        Long configuredChunkSize = options != null ? options.getChunkSizeInBytes() : null;
        int chunkSize = configuredChunkSize != null ? configuredChunkSize.intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, new StorageSeekableByteChannelShareFileReadBehavior(this, conditions), 0L);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Response<ShareFileProperties> response = this.getPropertiesWithResponse(timeout, context);
            return new SimpleResponse<Boolean>(response, true);
        }
        catch (RuntimeException e) {
            if (ModelHelper.checkDoesNotExistStatusCode(e) && e instanceof HttpResponseException) {
                HttpResponse response = ((HttpResponseException)e).getResponse();
                return new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo create(long maxSize) {
        return this.createWithResponse(maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(filePermission, "Inherit");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("None");
        String fileCreationTime = smbProperties.setFileCreationTime("Now");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Now");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().createWithResponse(this.shareName, this.filePath, maxSize, fileAttributes, null, metadata, finalFilePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), httpHeaders, finalContext);
        return ModelHelper.createFileInfoResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setMetadata(metadata);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setSmbProperties(smbProperties).setFilePermission(filePermission).setPermissionCopyModeType(filePermissionCopyMode).setIgnoreReadOnly(ignoreReadOnly).setArchiveAttribute(setArchiveAttribute).setMetadata(metadata).setDestinationRequestConditions(destinationRequestConditions);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, ShareFileCopyOptions options, Duration pollInterval) {
        ShareRequestConditions finalRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        AtomicReference copyId = new AtomicReference();
        Duration interval = pollInterval == null ? Duration.ofSeconds(1L) : pollInterval;
        FileSmbProperties tempSmbProperties = options.getSmbProperties() == null ? new FileSmbProperties() : options.getSmbProperties();
        String filePermissionKey = tempSmbProperties.getFilePermissionKey();
        if (options.getFilePermission() == null || options.getPermissionCopyModeType() == PermissionCopyModeType.SOURCE) {
            if ((options.getFilePermission() != null || filePermissionKey != null) && options.getPermissionCopyModeType() != PermissionCopyModeType.OVERRIDE) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("File permission and file permission key can not be set when PermissionCopyModeType is source or null"));
            }
        } else if (options.getPermissionCopyModeType() == PermissionCopyModeType.OVERRIDE) {
            try {
                ModelHelper.validateFilePermissionAndKey(options.getFilePermission(), tempSmbProperties.getFilePermissionKey());
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        }
        CopyableFileSmbPropertiesList list = options.getSmbPropertiesToCopy() == null ? new CopyableFileSmbPropertiesList() : options.getSmbPropertiesToCopy();
        try {
            ModelHelper.validateCopyFlagAndSmbProperties(options, tempSmbProperties);
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
        String fileAttributes = list.isFileAttributes() != false ? "Source" : NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
        String fileCreationTime = list.isCreatedOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
        String fileLastWriteTime = list.isLastWrittenOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
        String fileChangedOnTime = list.isChangedOn() != false ? "Source" : FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
        CopyFileSmbInfo copyFileSmbInfo = new CopyFileSmbInfo().setFilePermissionCopyMode(options.getPermissionCopyModeType()).setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangedOnTime).setIgnoreReadOnly(options.isIgnoreReadOnly()).setSetArchiveAttribute(options.isArchiveAttributeSet());
        String copySource = Utility.encodeUrlPath(sourceUrl);
        Function syncActivationOperation = pollingContext -> {
            ResponseBase<FilesStartCopyHeaders, Void> response = this.azureFileStorageClient.getFiles().startCopyWithResponse(this.shareName, this.filePath, copySource, null, options.getMetadata(), options.getFilePermission(), tempSmbProperties.getFilePermissionKey(), finalRequestConditions.getLeaseId(), copyFileSmbInfo, null);
            FilesStartCopyHeaders headers = response.getDeserializedHeaders();
            copyId.set(headers.getXMsCopyId());
            return new PollResponse<ShareFileCopyInfo>(LongRunningOperationStatus.IN_PROGRESS, new ShareFileCopyInfo(sourceUrl, headers.getXMsCopyId(), headers.getXMsCopyStatus(), headers.getETag(), headers.getLastModified(), response.getHeaders().getValue(HttpHeaderName.fromString("x-ms-error-code"))));
        };
        Function pollOperation = pollingContext -> this.onPoll(pollingContext.getLatestResponse(), finalRequestConditions);
        BiFunction<PollingContext, PollResponse, ShareFileCopyInfo> cancelOperation = (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Cannot cancel a poll response that never started."));
            }
            String copyIdentifier = ((ShareFileCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty(copyIdentifier)) {
                LOGGER.info("Cancelling copy operation for copy id: {}", copyIdentifier);
                this.abortCopyWithResponse(copyIdentifier, finalRequestConditions, null, null);
                return (ShareFileCopyInfo)firstResponse.getValue();
            }
            return null;
        };
        Function<PollingContext, Void> fetchResultOperation = pollingContext -> null;
        return SyncPoller.createPoller(interval, syncActivationOperation, pollOperation, cancelOperation, fetchResultOperation);
    }

    private PollResponse<ShareFileCopyInfo> onPoll(PollResponse<ShareFileCopyInfo> pollResponse, ShareRequestConditions requestConditions) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return pollResponse;
        }
        ShareFileCopyInfo lastInfo = pollResponse.getValue();
        if (lastInfo == null) {
            LOGGER.warning("ShareFileCopyInfo does not exist. Activation operation failed.");
            return new PollResponse<Object>(LongRunningOperationStatus.fromString("COPY_START_FAILED", true), null);
        }
        try {
            Response<ShareFileProperties> response = this.getPropertiesWithResponse(requestConditions, null, null);
            ShareFileProperties value = response.getValue();
            CopyStatusType status = value.getCopyStatus();
            ShareFileCopyInfo result = new ShareFileCopyInfo(value.getCopySource(), value.getCopyId(), status, value.getETag(), value.getCopyCompletionTime(), value.getCopyStatusDescription());
            LongRunningOperationStatus operationStatus = ModelHelper.mapStatusToLongRunningOperationStatus(status);
            return new PollResponse<ShareFileCopyInfo>(operationStatus, result);
        }
        catch (RuntimeException e) {
            return new PollResponse<ShareFileCopyInfo>(LongRunningOperationStatus.fromString("POLLING_FAILED", true), lastInfo);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopy(String copyId) {
        this.abortCopyWithResponse(copyId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, Duration timeout, Context context) {
        return this.abortCopyWithResponse(copyId, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().abortCopyNoCustomHeadersWithResponse(this.shareName, this.filePath, copyId, null, finalRequestConditions.getLeaseId(), finalContext);
        return StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties downloadToFile(String downloadFilePath) {
        return this.downloadToFileWithResponse(downloadFilePath, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.downloadToFileWithResponse(downloadFilePath, range, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public void download(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, Context.NONE);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, range, rangeGetContentMD5, null, timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, new ShareFileDownloadOptions().setRange(range).setRangeContentMd5Requested(rangeGetContentMD5).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileDownloadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(stream, "'stream' cannot be null.");
        Mono download = this.shareFileAsyncClient.downloadWithResponse(options, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)response.getValue(), stream).thenReturn(new ShareFileDownloadResponse((ShareFileDownloadAsyncResponse)response)));
        return (ShareFileDownloadResponse)StorageImplUtils.blockWithOptionalTimeout(download, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().deleteNoCustomHeadersWithResponse(this.shareName, this.filePath, null, finalRequestConditions.getLeaseId(), finalContext);
        return StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(requestConditions, timeout, context);
            return new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals(ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Boolean>(res.getRequest(), res.getStatusCode(), res.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties getProperties() {
        return this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().getPropertiesWithResponse(this.shareName, this.filePath, this.snapshot, null, finalRequestConditions.getLeaseId(), finalContext);
        return ModelHelper.getPropertiesResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        smbProperties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        ModelHelper.validateFilePermissionAndKey(filePermission, smbProperties.getFilePermissionKey());
        String finalFilePermission = smbProperties.setFilePermission(filePermission, "Preserve");
        String filePermissionKey = smbProperties.getFilePermissionKey();
        String fileAttributes = smbProperties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = smbProperties.setFileCreationTime("Preserve");
        String fileLastWriteTime = smbProperties.setFileLastWriteTime("Preserve");
        String fileChangeTime = smbProperties.getFileChangeTimeString();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().setHttpHeadersWithResponse(this.shareName, this.filePath, fileAttributes, null, newFileSize, finalFilePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, finalRequestConditions.getLeaseId(), httpHeaders, finalContext);
        return ModelHelper.setPropertiesResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileMetadataInfo setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().setMetadataWithResponse(this.shareName, this.filePath, null, metadata, finalRequestConditions.getLeaseId(), finalContext);
        return ModelHelper.setMetadataResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo upload(InputStream data, long length) {
        return this.uploadWithResponse(data, length, 0L, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, Duration timeout, Context context) {
        return this.uploadWithResponse(data, length, offset, null, timeout, context);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length).setOffset(offset).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileUploadInfo upload(InputStream data, long length, ParallelTransferOptions transferOptions) {
        return this.uploadWithResponse(new ShareFileUploadOptions(data, length).setParallelTransferOptions(transferOptions), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadWithResponse(ShareFileUploadOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadWithResponse(options, context), timeout);
    }

    public ShareFileUploadInfo uploadRange(InputStream data, long length) {
        return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadRangeWithResponse(ShareFileUploadRangeOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadRangeWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadRangeFromUrlInfo uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(new ShareFileUploadRangeFromUrlOptions(length, sourceUrl).setDestinationOffset(destinationOffset).setSourceOffset(sourceOffset).setDestinationRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(ShareFileUploadRangeFromUrlOptions options, Duration timeout, Context context) {
        ShareRequestConditions finalRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        ShareFileRange destinationRange = new ShareFileRange(options.getDestinationOffset(), options.getDestinationOffset() + options.getLength() - 1L);
        ShareFileRange sourceRange = new ShareFileRange(options.getSourceOffset(), options.getSourceOffset() + options.getLength() - 1L);
        Context finalContext = context == null ? Context.NONE : context;
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        String copySource = Utility.encodeUrlPath(options.getSourceUrl());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().uploadRangeFromURLWithResponse(this.shareName, this.filePath, destinationRange.toString(), copySource, 0L, null, sourceRange.toString(), null, finalRequestConditions.getLeaseId(), sourceAuth, options.getLastWrittenMode(), null, finalContext);
        return ModelHelper.mapUploadRangeFromUrlResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo clearRange(long length) {
        return this.clearRangeWithResponse(length, 0L, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, Duration timeout, Context context) {
        return this.clearRangeWithResponse(length, offset, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        ShareFileRange range = new ShareFileRange(offset, offset + length - 1L);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().uploadRangeWithResponse(this.shareName, this.filePath, range.toString(), ShareFileRangeWriteType.CLEAR, 0L, null, null, finalRequestConditions.getLeaseId(), null, null, finalContext);
        return ModelHelper.transformUploadResponse(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath) {
        this.uploadFromFile(uploadFilePath, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        this.shareFileAsyncClient.uploadFromFile(uploadFilePath, requestConditions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges() {
        return this.listRanges(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, Duration timeout, Context context) {
        return this.listRanges(range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        String rangeString = range == null ? null : range.toString();
        try {
            Supplier<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().getRangeListWithResponse(this.shareName, this.filePath, this.snapshot, null, null, rangeString, finalRequestConditions.getLeaseId(), null, finalContext);
            ResponseBase response = timeout != null ? CoreUtils.getResultWithTimeout(SharedExecutorService.getInstance().submit(operation::get), timeout) : operation.get();
            List shareFileRangeList = ((ShareFileRangeList)response.getValue()).getRanges().stream().map(r -> new Range().setStart(r.getStart()).setEnd(r.getEnd())).map(ShareFileRange::new).collect(Collectors.toList());
            Supplier finalResponse = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), shareFileRangeList, null, (FilesGetRangeListHeaders)response.getDeserializedHeaders());
            return new PagedIterable<ShareFileRange>(finalResponse);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileRangeList listRangesDiff(String previousSnapshot) {
        return this.listRangesDiffWithResponse(new ShareFileListRangesDiffOptions(previousSnapshot), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileRangeList> listRangesDiffWithResponse(ShareFileListRangesDiffOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        String rangeString = options.getRange() == null ? null : options.getRange().toString();
        Callable<Response> operation = () -> this.azureFileStorageClient.getFiles().getRangeListNoCustomHeadersWithResponse(this.shareName, this.filePath, this.snapshot, options.getPreviousSnapshot(), null, rangeString, requestConditions.getLeaseId(), options.isRenameIncluded(), finalContext);
        return StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles() {
        return this.listHandles(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Supplier<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().listHandlesWithResponse(this.shareName, this.filePath, null, maxResultsPerPage, null, this.snapshot, finalContext);
            ResponseBase response = timeout != null ? CoreUtils.getResultWithTimeout(SharedExecutorService.getInstance().submit(operation::get), timeout) : operation.get();
            Supplier finalResponse = () -> new PagedResponseBase<FilesListHandlesHeaders, HandleItem>(response.getRequest(), response.getStatusCode(), response.getHeaders(), ModelHelper.transformHandleItems(((ListHandlesResponse)response.getValue()).getHandleList()), null, (FilesListHandlesHeaders)response.getDeserializedHeaders());
            return new PagedIterable<HandleItem>(finalResponse);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponse(this.shareName, this.filePath, handleId, null, null, this.snapshot, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class);
        return new SimpleResponse<CloseHandlesInfo>(response, new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseAllHandles(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Supplier<ResponseBase> operation = () -> this.azureFileStorageClient.getFiles().forceCloseHandlesWithResponse(this.shareName, this.filePath, "*", null, null, this.snapshot, finalContext);
            ResponseBase response = timeout != null ? CoreUtils.getResultWithTimeout(SharedExecutorService.getInstance().submit(operation::get), timeout) : operation.get();
            Supplier finalResponse = () -> new PagedResponseBase<FilesForceCloseHandlesHeaders, CloseHandlesInfo>(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())), ((FilesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsMarker(), (FilesForceCloseHandlesHeaders)response.getDeserializedHeaders());
            return new PagedIterable(finalResponse).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient rename(String destinationPath) {
        return this.renameWithResponse(new ShareFileRenameOptions(destinationPath), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> renameWithResponse(ShareFileRenameOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new ShareRequestConditions() : options.getSourceRequestConditions();
        ShareRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        SourceLeaseAccessConditions sourceConditions = new SourceLeaseAccessConditions().setSourceLeaseId(sourceRequestConditions.getLeaseId());
        DestinationLeaseAccessConditions destinationConditions = new DestinationLeaseAccessConditions().setDestinationLeaseId(destinationRequestConditions.getLeaseId());
        CopyFileSmbInfo smbInfo = null;
        String filePermissionKey = null;
        if (options.getSmbProperties() != null) {
            FileSmbProperties tempSmbProperties = options.getSmbProperties();
            filePermissionKey = tempSmbProperties.getFilePermissionKey();
            String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
            String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
            String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
            String fileChangeTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
            smbInfo = new CopyFileSmbInfo().setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangeTime).setIgnoreReadOnly(options.isIgnoreReadOnly());
        }
        CopyFileSmbInfo finalSmbInfo = smbInfo;
        String finalFilePermissionKey = filePermissionKey;
        ShareFileClient destinationFileClient = this.getFileClient(options.getDestinationPath());
        ShareFileHttpHeaders headers = options.getContentType() == null ? null : new ShareFileHttpHeaders().setContentType(options.getContentType());
        String renameSource = Utility.encodeUrlPath(this.getFileUrl());
        String finalRenameSource = this.sasToken != null ? renameSource + "?" + this.sasToken.getSignature() : renameSource;
        Callable<Response> operation = () -> destinationFileClient.azureFileStorageClient.getFiles().renameNoCustomHeadersWithResponse(destinationFileClient.getShareName(), destinationFileClient.getFilePath(), finalRenameSource, null, options.getReplaceIfExists(), options.isIgnoreReadOnly(), options.getFilePermission(), finalFilePermissionKey, options.getMetadata(), sourceConditions, destinationConditions, finalSmbInfo, headers, finalContext);
        return new SimpleResponse<ShareFileClient>(StorageImplUtils.sendRequest(operation, timeout, ShareStorageException.class), destinationFileClient);
    }

    ShareFileClient getFileClient(String destinationPath) {
        if (CoreUtils.isNullOrEmpty(destinationPath)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new ShareFileClient(this.shareFileAsyncClient, this.azureFileStorageClient, this.getShareName(), destinationPath, null, this.getAccountName(), this.getServiceVersion(), this.getSasToken());
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    AzureSasCredential getSasToken() {
        return this.sasToken;
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getFilePath()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), context);
    }
}

