/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileDownloadHeaders;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileDownloadOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class StorageSeekableByteChannelShareFileReadBehavior
implements StorageSeekableByteChannel.ReadBehavior {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSeekableByteChannelShareFileReadBehavior.class);
    private static final long UNKNOWN_LENGTH = -1L;
    private final ShareFileClient client;
    private final ShareRequestConditions conditions;
    private long lastKnownResourceLength;

    StorageSeekableByteChannelShareFileReadBehavior(ShareFileClient client, ShareRequestConditions conditions) {
        this.client = client;
        this.conditions = conditions;
        this.lastKnownResourceLength = -1L;
    }

    ShareFileClient getClient() {
        return this.client;
    }

    ShareRequestConditions getRequestConditions() {
        return this.conditions;
    }

    @Override
    public int read(ByteBuffer dst, long sourceOffset) throws IOException {
        int n;
        if (dst.remaining() <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'dst.remaining()' must be positive."));
        }
        int initialPosition = dst.position();
        ByteBufferBackedOutputStream dstStream = new ByteBufferBackedOutputStream(dst);
        try {
            ShareFileDownloadResponse response = this.client.downloadWithResponse(dstStream, new ShareFileDownloadOptions().setRange(new ShareFileRange(sourceOffset, sourceOffset + (long)dst.remaining() - 1L)).setRequestConditions(this.conditions), null, null);
            this.lastKnownResourceLength = CoreUtils.extractSizeFromContentRange(((ShareFileDownloadHeaders)response.getDeserializedHeaders()).getContentRange());
            n = dst.position() - initialPosition;
        }
        catch (Throwable response) {
            try {
                try {
                    dstStream.close();
                }
                catch (Throwable throwable) {
                    response.addSuppressed(throwable);
                }
                throw response;
            }
            catch (ShareStorageException e) {
                if (e.getErrorCode() == ShareErrorCode.INVALID_RANGE) {
                    String contentRange = e.getResponse().getHeaderValue("Content-Range");
                    if (contentRange != null) {
                        this.lastKnownResourceLength = CoreUtils.extractSizeFromContentRange(contentRange);
                    }
                    return sourceOffset < this.lastKnownResourceLength ? 0 : -1;
                }
                throw LOGGER.logExceptionAsError(e);
            }
        }
        dstStream.close();
        return n;
    }

    @Override
    public long getResourceLength() {
        if (this.lastKnownResourceLength == -1L) {
            this.lastKnownResourceLength = this.client.getProperties().getContentLength();
        }
        return this.lastKnownResourceLength;
    }

    private static final class ByteBufferBackedOutputStream
    extends OutputStream {
        private final ByteBuffer dst;

        ByteBufferBackedOutputStream(ByteBuffer dst) {
            this.dst = dst;
        }

        @Override
        public void write(int b) {
            this.dst.put((byte)b);
        }

        @Override
        public void write(byte[] b) {
            this.dst.put(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.dst.put(b, off, len);
        }
    }
}

