/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.FilesAbortCopyHeaders;
import com.azure.storage.file.share.implementation.models.FilesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FilesBreakLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FilesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FilesCreateHeaders;
import com.azure.storage.file.share.implementation.models.FilesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.FilesDownloadHeaders;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListHeaders;
import com.azure.storage.file.share.implementation.models.FilesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.FilesReleaseLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FilesRenameHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetHttpHeadersHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.FilesStartCopyHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeHeaders;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.models.FileLastWrittenMode;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.ShareTokenIntent;
import com.azure.storage.file.share.models.SourceModifiedAccessConditions;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FilesImpl {
    private final FilesService service;
    private final AzureFileStorageImpl client;

    FilesImpl(AzureFileStorageImpl client) {
        this.service = RestProxy.create(FilesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesCreateHeaders, Void>> createWithResponseAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesCreateHeaders, Void>> createWithResponseAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.create(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        return this.createWithResponseAsync(shareName, fileName, fileContentLength, fileAttributes, timeout, metadata, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        return this.createWithResponseAsync(shareName, fileName, fileContentLength, fileAttributes, timeout, metadata, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return FluxUtil.withContext(context -> this.service.createNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.createNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesCreateHeaders, Void> createWithResponse(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.createSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        this.createWithResponse(shareName, fileName, fileContentLength, fileAttributes, timeout, metadata, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.createNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesDownloadHeaders, Flux<ByteBuffer>>> downloadWithResponseAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.download(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesDownloadHeaders, Flux<ByteBuffer>>> downloadWithResponseAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.download(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> downloadAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId) {
        return this.downloadWithResponseAsync(shareName, fileName, timeout, range, rangeGetContentMD5, leaseId).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> downloadAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        return this.downloadWithResponseAsync(shareName, fileName, timeout, range, rangeGetContentMD5, leaseId, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> downloadNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.downloadNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> downloadNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.downloadNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesDownloadHeaders, InputStream> downloadWithResponse(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.downloadSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream download(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId) {
        return this.downloadWithResponse(shareName, fileName, timeout, range, rangeGetContentMD5, leaseId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InputStream> downloadNoCustomHeadersWithResponse(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.downloadNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId) {
        return this.getPropertiesWithResponseAsync(shareName, fileName, sharesnapshot, timeout, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        return this.getPropertiesWithResponseAsync(shareName, fileName, sharesnapshot, timeout, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesGetPropertiesHeaders, Void> getPropertiesWithResponse(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.getPropertiesSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId) {
        this.getPropertiesWithResponse(shareName, fileName, sharesnapshot, timeout, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String fileName, Integer timeout, String leaseId) {
        return this.deleteWithResponseAsync(shareName, fileName, timeout, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        return this.deleteWithResponseAsync(shareName, fileName, timeout, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.deleteNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesDeleteHeaders, Void> deleteWithResponse(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.deleteSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String shareName, String fileName, Integer timeout, String leaseId) {
        this.deleteWithResponse(shareName, fileName, timeout, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesSetHttpHeadersHeaders, Void>> setHttpHeadersWithResponseAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return FluxUtil.withContext(context -> this.service.setHttpHeaders(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesSetHttpHeadersHeaders, Void>> setHttpHeadersWithResponseAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.setHttpHeaders(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setHttpHeadersAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        return this.setHttpHeadersWithResponseAsync(shareName, fileName, fileAttributes, timeout, fileContentLength, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setHttpHeadersAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        return this.setHttpHeadersWithResponseAsync(shareName, fileName, fileAttributes, timeout, fileContentLength, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setHttpHeadersNoCustomHeadersWithResponseAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return FluxUtil.withContext(context -> this.service.setHttpHeadersNoCustomHeaders(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setHttpHeadersNoCustomHeadersWithResponseAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.setHttpHeadersNoCustomHeaders(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesSetHttpHeadersHeaders, Void> setHttpHeadersWithResponse(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.setHttpHeadersSync(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setHttpHeaders(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders) {
        this.setHttpHeadersWithResponse(shareName, fileName, fileAttributes, timeout, fileContentLength, filePermission, filePermissionKey, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, shareFileHttpHeaders, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setHttpHeadersNoCustomHeadersWithResponse(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        return this.service.setHttpHeadersNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRangeWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return FluxUtil.withContext(context -> this.service.uploadRange(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRangeWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRange(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody) {
        return this.uploadRangeWithResponseAsync(shareName, fileName, range, fileRangeWrite, contentLength, timeout, contentMD5, leaseId, fileLastWrittenMode, optionalbody).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody, Context context) {
        return this.uploadRangeWithResponseAsync(shareName, fileName, range, fileRangeWrite, contentLength, timeout, contentMD5, leaseId, fileLastWrittenMode, optionalbody, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return FluxUtil.withContext(context -> this.service.uploadRangeNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRangeNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRangeWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return FluxUtil.withContext(context -> this.service.uploadRange(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRangeWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRange(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody) {
        return this.uploadRangeWithResponseAsync(shareName, fileName, range, fileRangeWrite, contentLength, timeout, contentMD5, leaseId, fileLastWrittenMode, optionalbody).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody, Context context) {
        return this.uploadRangeWithResponseAsync(shareName, fileName, range, fileRangeWrite, contentLength, timeout, contentMD5, leaseId, fileLastWrittenMode, optionalbody, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return FluxUtil.withContext(context -> this.service.uploadRangeNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRangeNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, (Boolean)this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesUploadRangeHeaders, Void> uploadRangeWithResponse(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRangeSync(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadRange(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody) {
        this.uploadRangeWithResponse(shareName, fileName, range, fileRangeWrite, contentLength, timeout, contentMD5, leaseId, fileLastWrittenMode, optionalbody, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> uploadRangeNoCustomHeadersWithResponse(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, BinaryData optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString(contentMD5);
        return this.service.uploadRangeNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId) {
        String comp = "metadata";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setMetadata(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId) {
        return this.setMetadataWithResponseAsync(shareName, fileName, timeout, metadata, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        return this.setMetadataWithResponseAsync(shareName, fileName, timeout, metadata, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId) {
        String comp = "metadata";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setMetadataNoCustomHeaders(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataNoCustomHeaders(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesSetMetadataHeaders, Void> setMetadataWithResponse(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataSync(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId) {
        this.setMetadataWithResponse(shareName, fileName, timeout, metadata, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.acquireLease(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return this.service.acquireLease(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId) {
        return this.acquireLeaseWithResponseAsync(shareName, fileName, timeout, duration, proposedLeaseId, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        return this.acquireLeaseWithResponseAsync(shareName, fileName, timeout, duration, proposedLeaseId, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.acquireLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return this.service.acquireLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesAcquireLeaseHeaders, Void> acquireLeaseWithResponse(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return this.service.acquireLeaseSync(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void acquireLease(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId) {
        this.acquireLeaseWithResponse(shareName, fileName, timeout, duration, proposedLeaseId, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> acquireLeaseNoCustomHeadersWithResponse(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return this.service.acquireLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.releaseLease(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return this.service.releaseLease(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId) {
        return this.releaseLeaseWithResponseAsync(shareName, fileName, leaseId, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        return this.releaseLeaseWithResponseAsync(shareName, fileName, leaseId, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.releaseLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return this.service.releaseLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesReleaseLeaseHeaders, Void> releaseLeaseWithResponse(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return this.service.releaseLeaseSync(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease(String shareName, String fileName, String leaseId, Integer timeout, String requestId) {
        this.releaseLeaseWithResponse(shareName, fileName, leaseId, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseNoCustomHeadersWithResponse(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return this.service.releaseLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.changeLease(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return this.service.changeLease(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId) {
        return this.changeLeaseWithResponseAsync(shareName, fileName, leaseId, timeout, proposedLeaseId, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        return this.changeLeaseWithResponseAsync(shareName, fileName, leaseId, timeout, proposedLeaseId, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.changeLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return this.service.changeLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesChangeLeaseHeaders, Void> changeLeaseWithResponse(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return this.service.changeLeaseSync(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void changeLease(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId) {
        this.changeLeaseWithResponse(shareName, fileName, leaseId, timeout, proposedLeaseId, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> changeLeaseNoCustomHeadersWithResponse(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return this.service.changeLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.breakLease(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return this.service.breakLease(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId) {
        return this.breakLeaseWithResponseAsync(shareName, fileName, timeout, leaseId, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        return this.breakLeaseWithResponseAsync(shareName, fileName, timeout, leaseId, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.breakLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return this.service.breakLeaseNoCustomHeaders(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesBreakLeaseHeaders, Void> breakLeaseWithResponse(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return this.service.breakLeaseSync(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void breakLease(String shareName, String fileName, Integer timeout, String leaseId, String requestId) {
        this.breakLeaseWithResponse(shareName, fileName, timeout, leaseId, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseNoCustomHeadersWithResponse(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return this.service.breakLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeFromURLHeaders, Void>> uploadRangeFromURLWithResponseAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return FluxUtil.withContext(context -> this.service.uploadRangeFromURL(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesUploadRangeFromURLHeaders, Void>> uploadRangeFromURLWithResponseAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURL(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeFromURLAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        return this.uploadRangeFromURLWithResponseAsync(shareName, fileName, range, copySource, contentLength, timeout, sourceRange, sourceContentCrc64, leaseId, copySourceAuthorization, fileLastWrittenMode, sourceModifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadRangeFromURLAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        return this.uploadRangeFromURLWithResponseAsync(shareName, fileName, range, copySource, contentLength, timeout, sourceRange, sourceContentCrc64, leaseId, copySourceAuthorization, fileLastWrittenMode, sourceModifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeFromURLNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return FluxUtil.withContext(context -> this.service.uploadRangeFromURLNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadRangeFromURLNoCustomHeadersWithResponseAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURLNoCustomHeaders(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesUploadRangeFromURLHeaders, Void> uploadRangeFromURLWithResponse(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURLSync(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadRangeFromURL(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        this.uploadRangeFromURLWithResponse(shareName, fileName, range, copySource, contentLength, timeout, sourceRange, sourceContentCrc64, leaseId, copySourceAuthorization, fileLastWrittenMode, sourceModifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> uploadRangeFromURLNoCustomHeadersWithResponse(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString(sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString(sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString(sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURLNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesGetRangeListHeaders, ShareFileRangeList>> getRangeListWithResponseAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename) {
        String comp = "rangelist";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getRangeList(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesGetRangeListHeaders, ShareFileRangeList>> getRangeListWithResponseAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename, Context context) {
        String comp = "rangelist";
        String accept = "application/xml";
        return this.service.getRangeList(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileRangeList> getRangeListAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename) {
        return this.getRangeListWithResponseAsync(shareName, fileName, sharesnapshot, prevsharesnapshot, timeout, range, leaseId, supportRename).flatMap(res -> Mono.justOrEmpty((ShareFileRangeList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileRangeList> getRangeListAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename, Context context) {
        return this.getRangeListWithResponseAsync(shareName, fileName, sharesnapshot, prevsharesnapshot, timeout, range, leaseId, supportRename, context).flatMap(res -> Mono.justOrEmpty((ShareFileRangeList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileRangeList>> getRangeListNoCustomHeadersWithResponseAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename) {
        String comp = "rangelist";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getRangeListNoCustomHeaders(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileRangeList>> getRangeListNoCustomHeadersWithResponseAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename, Context context) {
        String comp = "rangelist";
        String accept = "application/xml";
        return this.service.getRangeListNoCustomHeaders(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesGetRangeListHeaders, ShareFileRangeList> getRangeListWithResponse(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename, Context context) {
        String comp = "rangelist";
        String accept = "application/xml";
        return this.service.getRangeListSync(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileRangeList getRangeList(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename) {
        return this.getRangeListWithResponse(shareName, fileName, sharesnapshot, prevsharesnapshot, timeout, range, leaseId, supportRename, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileRangeList> getRangeListNoCustomHeadersWithResponse(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Boolean supportRename, Context context) {
        String comp = "rangelist";
        String accept = "application/xml";
        return this.service.getRangeListNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), supportRename, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesStartCopyHeaders, Void>> startCopyWithResponseAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return FluxUtil.withContext(context -> this.service.startCopy(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesStartCopyHeaders, Void>> startCopyWithResponseAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return this.service.startCopy(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startCopyAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo) {
        return this.startCopyWithResponseAsync(shareName, fileName, copySource, timeout, metadata, filePermission, filePermissionKey, leaseId, copyFileSmbInfo).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startCopyAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        return this.startCopyWithResponseAsync(shareName, fileName, copySource, timeout, metadata, filePermission, filePermissionKey, leaseId, copyFileSmbInfo, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startCopyNoCustomHeadersWithResponseAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return FluxUtil.withContext(context -> this.service.startCopyNoCustomHeaders(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startCopyNoCustomHeadersWithResponseAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return this.service.startCopyNoCustomHeaders(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesStartCopyHeaders, Void> startCopyWithResponse(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return this.service.startCopySync(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startCopy(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo) {
        this.startCopyWithResponse(shareName, fileName, copySource, timeout, metadata, filePermission, filePermissionKey, leaseId, copyFileSmbInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startCopyNoCustomHeadersWithResponse(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return this.service.startCopyNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesAbortCopyHeaders, Void>> abortCopyWithResponseAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.abortCopy(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesAbortCopyHeaders, Void>> abortCopyWithResponseAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopy(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> abortCopyAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId) {
        return this.abortCopyWithResponseAsync(shareName, fileName, copyId, timeout, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> abortCopyAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        return this.abortCopyWithResponseAsync(shareName, fileName, copyId, timeout, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> abortCopyNoCustomHeadersWithResponseAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.abortCopyNoCustomHeaders(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> abortCopyNoCustomHeadersWithResponseAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopyNoCustomHeaders(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesAbortCopyHeaders, Void> abortCopyWithResponse(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopySync(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopy(String shareName, String fileName, String copyId, Integer timeout, String leaseId) {
        this.abortCopyWithResponse(shareName, fileName, copyId, timeout, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyNoCustomHeadersWithResponse(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopyNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesListHandlesHeaders, ListHandlesResponse>> listHandlesWithResponseAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot) {
        String comp = "listhandles";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listHandles(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesListHandlesHeaders, ListHandlesResponse>> listHandlesWithResponseAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListHandlesResponse> listHandlesAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot) {
        return this.listHandlesWithResponseAsync(shareName, fileName, marker, maxresults, timeout, sharesnapshot).flatMap(res -> Mono.justOrEmpty((ListHandlesResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListHandlesResponse> listHandlesAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        return this.listHandlesWithResponseAsync(shareName, fileName, marker, maxresults, timeout, sharesnapshot, context).flatMap(res -> Mono.justOrEmpty((ListHandlesResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot) {
        String comp = "listhandles";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listHandlesNoCustomHeaders(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandlesNoCustomHeaders(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesListHandlesHeaders, ListHandlesResponse> listHandlesWithResponse(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandlesSync(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListHandlesResponse listHandles(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot) {
        return this.listHandlesWithResponse(shareName, fileName, marker, maxresults, timeout, sharesnapshot, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListHandlesResponse> listHandlesNoCustomHeadersWithResponse(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandlesNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesForceCloseHandlesHeaders, Void>> forceCloseHandlesWithResponseAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.forceCloseHandles(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesForceCloseHandlesHeaders, Void>> forceCloseHandlesWithResponseAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> forceCloseHandlesAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot) {
        return this.forceCloseHandlesWithResponseAsync(shareName, fileName, handleId, timeout, marker, sharesnapshot).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> forceCloseHandlesAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        return this.forceCloseHandlesWithResponseAsync(shareName, fileName, handleId, timeout, marker, sharesnapshot, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> forceCloseHandlesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.forceCloseHandlesNoCustomHeaders(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> forceCloseHandlesNoCustomHeadersWithResponseAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandlesNoCustomHeaders(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesForceCloseHandlesHeaders, Void> forceCloseHandlesWithResponse(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandlesSync(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void forceCloseHandles(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot) {
        this.forceCloseHandlesWithResponse(shareName, fileName, handleId, timeout, marker, sharesnapshot, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> forceCloseHandlesNoCustomHeadersWithResponse(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandlesNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesRenameHeaders, Void>> renameWithResponseAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return FluxUtil.withContext(context -> this.service.rename(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FilesRenameHeaders, Void>> renameWithResponseAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return this.service.rename(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders) {
        return this.renameWithResponseAsync(shareName, fileName, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, shareFileHttpHeaders).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        return this.renameWithResponseAsync(shareName, fileName, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, shareFileHttpHeaders, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return FluxUtil.withContext(context -> this.service.renameNoCustomHeaders(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return this.service.renameNoCustomHeaders(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FilesRenameHeaders, Void> renameWithResponse(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return this.service.renameSync(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rename(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders) {
        this.renameWithResponse(shareName, fileName, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, shareFileHttpHeaders, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameNoCustomHeadersWithResponse(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return this.service.renameNoCustomHeadersSync(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageFile")
    public static interface FilesService {
        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") long var7, @HeaderParam(value="x-ms-type") String var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-md5") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-meta-") Map<String, String> var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-key") String var18, @HeaderParam(value="x-ms-file-attributes") String var19, @HeaderParam(value="x-ms-file-creation-time") String var20, @HeaderParam(value="x-ms-file-last-write-time") String var21, @HeaderParam(value="x-ms-file-change-time") String var22, @HeaderParam(value="x-ms-lease-id") String var23, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") long var7, @HeaderParam(value="x-ms-type") String var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-md5") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-meta-") Map<String, String> var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-key") String var18, @HeaderParam(value="x-ms-file-attributes") String var19, @HeaderParam(value="x-ms-file-creation-time") String var20, @HeaderParam(value="x-ms-file-last-write-time") String var21, @HeaderParam(value="x-ms-file-change-time") String var22, @HeaderParam(value="x-ms-lease-id") String var23, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") long var7, @HeaderParam(value="x-ms-type") String var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-md5") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-meta-") Map<String, String> var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-key") String var18, @HeaderParam(value="x-ms-file-attributes") String var19, @HeaderParam(value="x-ms-file-creation-time") String var20, @HeaderParam(value="x-ms-file-last-write-time") String var21, @HeaderParam(value="x-ms-file-change-time") String var22, @HeaderParam(value="x-ms-lease-id") String var23, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") long var7, @HeaderParam(value="x-ms-type") String var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-md5") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-meta-") Map<String, String> var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-key") String var18, @HeaderParam(value="x-ms-file-attributes") String var19, @HeaderParam(value="x-ms-file-creation-time") String var20, @HeaderParam(value="x-ms-file-last-write-time") String var21, @HeaderParam(value="x-ms-file-change-time") String var22, @HeaderParam(value="x-ms-lease-id") String var23, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesDownloadHeaders, Flux<ByteBuffer>>> download(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<StreamResponse> downloadNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesDownloadHeaders, InputStream> downloadSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<InputStream> downloadNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Head(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Head(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Head(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Head(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesSetHttpHeadersHeaders, Void>> setHttpHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") Long var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-file-permission") String var14, @HeaderParam(value="x-ms-file-permission-key") String var15, @HeaderParam(value="x-ms-file-attributes") String var16, @HeaderParam(value="x-ms-file-creation-time") String var17, @HeaderParam(value="x-ms-file-last-write-time") String var18, @HeaderParam(value="x-ms-file-change-time") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> setHttpHeadersNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") Long var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-file-permission") String var14, @HeaderParam(value="x-ms-file-permission-key") String var15, @HeaderParam(value="x-ms-file-attributes") String var16, @HeaderParam(value="x-ms-file-creation-time") String var17, @HeaderParam(value="x-ms-file-last-write-time") String var18, @HeaderParam(value="x-ms-file-change-time") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesSetHttpHeadersHeaders, Void> setHttpHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") Long var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-file-permission") String var14, @HeaderParam(value="x-ms-file-permission-key") String var15, @HeaderParam(value="x-ms-file-attributes") String var16, @HeaderParam(value="x-ms-file-creation-time") String var17, @HeaderParam(value="x-ms-file-last-write-time") String var18, @HeaderParam(value="x-ms-file-change-time") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> setHttpHeadersNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") Long var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-file-permission") String var14, @HeaderParam(value="x-ms-file-permission-key") String var15, @HeaderParam(value="x-ms-file-attributes") String var16, @HeaderParam(value="x-ms-file-creation-time") String var17, @HeaderParam(value="x-ms-file-last-write-time") String var18, @HeaderParam(value="x-ms-file-change-time") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRange(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> uploadRangeNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesUploadRangeHeaders, Void>> uploadRange(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") BinaryData var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> uploadRangeNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") BinaryData var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesUploadRangeHeaders, Void> uploadRangeSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") BinaryData var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> uploadRangeNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @BodyParam(value="application/octet-stream") BinaryData var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesSetMetadataHeaders, Void> setMetadataSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> setMetadataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesAcquireLeaseHeaders, Void>> acquireLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> acquireLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesAcquireLeaseHeaders, Void> acquireLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> acquireLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesReleaseLeaseHeaders, Void>> releaseLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> releaseLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesReleaseLeaseHeaders, Void> releaseLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> releaseLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesChangeLeaseHeaders, Void>> changeLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> changeLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesChangeLeaseHeaders, Void> changeLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> changeLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesBreakLeaseHeaders, Void>> breakLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> breakLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesBreakLeaseHeaders, Void> breakLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> breakLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesUploadRangeFromURLHeaders, Void>> uploadRangeFromURL(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-write") String var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="x-ms-source-content-crc64") String var12, @HeaderParam(value="x-ms-source-if-match-crc64") String var13, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-copy-source-authorization") String var17, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var18, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var21, @HeaderParam(value="Accept") String var22, Context var23);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> uploadRangeFromURLNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-write") String var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="x-ms-source-content-crc64") String var12, @HeaderParam(value="x-ms-source-if-match-crc64") String var13, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-copy-source-authorization") String var17, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var18, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var21, @HeaderParam(value="Accept") String var22, Context var23);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesUploadRangeFromURLHeaders, Void> uploadRangeFromURLSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-write") String var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="x-ms-source-content-crc64") String var12, @HeaderParam(value="x-ms-source-if-match-crc64") String var13, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-copy-source-authorization") String var17, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var18, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var21, @HeaderParam(value="Accept") String var22, Context var23);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> uploadRangeFromURLNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-write") String var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="x-ms-source-content-crc64") String var12, @HeaderParam(value="x-ms-source-if-match-crc64") String var13, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-copy-source-authorization") String var17, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var18, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var21, @HeaderParam(value="Accept") String var22, Context var23);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesGetRangeListHeaders, ShareFileRangeList>> getRangeList(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="prevsharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="x-ms-file-support-rename") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<ShareFileRangeList>> getRangeListNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="prevsharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="x-ms-file-support-rename") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesGetRangeListHeaders, ShareFileRangeList> getRangeListSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="prevsharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="x-ms-file-support-rename") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<ShareFileRangeList> getRangeListNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="prevsharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="x-ms-file-support-rename") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesStartCopyHeaders, Void>> startCopy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var10, @HeaderParam(value="x-ms-file-copy-ignore-readonly") Boolean var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var18, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> startCopyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var10, @HeaderParam(value="x-ms-file-copy-ignore-readonly") Boolean var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var18, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesStartCopyHeaders, Void> startCopySync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var10, @HeaderParam(value="x-ms-file-copy-ignore-readonly") Boolean var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var18, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> startCopyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var10, @HeaderParam(value="x-ms-file-copy-ignore-readonly") Boolean var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var18, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var19, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesAbortCopyHeaders, Void>> abortCopy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="copyid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-copy-action") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> abortCopyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="copyid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-copy-action") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesAbortCopyHeaders, Void> abortCopySync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="copyid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-copy-action") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> abortCopyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="copyid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-copy-action") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesListHandlesHeaders, ListHandlesResponse>> listHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesListHandlesHeaders, ListHandlesResponse> listHandlesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<ListHandlesResponse> listHandlesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesForceCloseHandlesHeaders, Void>> forceCloseHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> forceCloseHandlesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesForceCloseHandlesHeaders, Void> forceCloseHandlesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> forceCloseHandlesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<FilesRenameHeaders, Void>> rename(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-rename-source") String var7, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var8, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var9, @HeaderParam(value="x-ms-source-lease-id") String var10, @HeaderParam(value="x-ms-destination-lease-id") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-meta-") Map<String, String> var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<Response<Void>> renameNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-rename-source") String var7, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var8, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var9, @HeaderParam(value="x-ms-source-lease-id") String var10, @HeaderParam(value="x-ms-destination-lease-id") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-meta-") Map<String, String> var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public ResponseBase<FilesRenameHeaders, Void> renameSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-rename-source") String var7, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var8, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var9, @HeaderParam(value="x-ms-source-lease-id") String var10, @HeaderParam(value="x-ms-destination-lease-id") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-meta-") Map<String, String> var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Response<Void> renameNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-rename-source") String var7, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var8, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var9, @HeaderParam(value="x-ms-source-lease-id") String var10, @HeaderParam(value="x-ms-destination-lease-id") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-meta-") Map<String, String> var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var20, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var22, @HeaderParam(value="Accept") String var23, Context var24);
    }
}

