/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.implementation.models.SharePropertiesInternal;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareItemInternal
implements XmlSerializable<ShareItemInternal> {
    private String name;
    private String snapshot;
    private Boolean deleted;
    private String version;
    private SharePropertiesInternal properties;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public ShareItemInternal setName(String name) {
        this.name = name;
        return this;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public ShareItemInternal setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public ShareItemInternal setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ShareItemInternal setVersion(String version) {
        this.version = version;
        return this;
    }

    public SharePropertiesInternal getProperties() {
        return this.properties;
    }

    public ShareItemInternal setProperties(SharePropertiesInternal properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareItemInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareItemInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareItemInternal.fromXml(xmlReader, null);
    }

    public static ShareItemInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareItemInternal deserializedShareItemInternal = new ShareItemInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedShareItemInternal.name = reader.getStringElement();
                    continue;
                }
                if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedShareItemInternal.snapshot = reader.getStringElement();
                    continue;
                }
                if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedShareItemInternal.deleted = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedShareItemInternal.version = reader.getStringElement();
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedShareItemInternal.properties = SharePropertiesInternal.fromXml(reader, "Properties");
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedShareItemInternal.metadata == null) {
                            deserializedShareItemInternal.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedShareItemInternal.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareItemInternal;
        });
    }
}

