/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SharePropertiesInternal
implements XmlSerializable<SharePropertiesInternal> {
    private DateTimeRfc1123 lastModified;
    private String eTag;
    private int quota;
    private Integer provisionedIops;
    private Integer provisionedIngressMBps;
    private Integer provisionedEgressMBps;
    private Integer provisionedBandwidthMiBps;
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    private DateTimeRfc1123 deletedTime;
    private Integer remainingRetentionDays;
    private String accessTier;
    private DateTimeRfc1123 accessTierChangeTime;
    private String accessTierTransitionState;
    private LeaseStatusType leaseStatus;
    private LeaseStateType leaseState;
    private LeaseDurationType leaseDuration;
    private String enabledProtocols;
    private ShareRootSquash rootSquash;
    private Boolean enableSnapshotVirtualDirectoryAccess;
    private Map<String, String> metadata;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharePropertiesInternal setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharePropertiesInternal setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public int getQuota() {
        return this.quota;
    }

    public SharePropertiesInternal setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    public SharePropertiesInternal setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    public SharePropertiesInternal setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    public SharePropertiesInternal setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    public Integer getProvisionedBandwidthMiBps() {
        return this.provisionedBandwidthMiBps;
    }

    public SharePropertiesInternal setProvisionedBandwidthMiBps(Integer provisionedBandwidthMiBps) {
        this.provisionedBandwidthMiBps = provisionedBandwidthMiBps;
        return this;
    }

    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public SharePropertiesInternal setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        this.nextAllowedQuotaDowngradeTime = nextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public SharePropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public SharePropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public SharePropertiesInternal setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public SharePropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    public SharePropertiesInternal setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public SharePropertiesInternal setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public SharePropertiesInternal setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public SharePropertiesInternal setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public SharePropertiesInternal setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public ShareRootSquash getRootSquash() {
        return this.rootSquash;
    }

    public SharePropertiesInternal setRootSquash(ShareRootSquash rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public Boolean isEnableSnapshotVirtualDirectoryAccess() {
        return this.enableSnapshotVirtualDirectoryAccess;
    }

    public SharePropertiesInternal setEnableSnapshotVirtualDirectoryAccess(Boolean enableSnapshotVirtualDirectoryAccess) {
        this.enableSnapshotVirtualDirectoryAccess = enableSnapshotVirtualDirectoryAccess;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public SharePropertiesInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SharePropertiesInternal" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeIntElement("Quota", this.quota);
        xmlWriter.writeNumberElement("ProvisionedIops", this.provisionedIops);
        xmlWriter.writeNumberElement("ProvisionedIngressMBps", this.provisionedIngressMBps);
        xmlWriter.writeNumberElement("ProvisionedEgressMBps", this.provisionedEgressMBps);
        xmlWriter.writeNumberElement("ProvisionedBandwidthMiBps", this.provisionedBandwidthMiBps);
        xmlWriter.writeStringElement("NextAllowedQuotaDowngradeTime", Objects.toString(this.nextAllowedQuotaDowngradeTime, null));
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeStringElement("AccessTier", this.accessTier);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeStringElement("AccessTierTransitionState", this.accessTierTransitionState);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration", this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("EnabledProtocols", this.enabledProtocols);
        xmlWriter.writeStringElement("RootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        xmlWriter.writeBooleanElement("EnableSnapshotVirtualDirectoryAccess", this.enableSnapshotVirtualDirectoryAccess);
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static SharePropertiesInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SharePropertiesInternal.fromXml(xmlReader, null);
    }

    public static SharePropertiesInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SharePropertiesInternal" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            SharePropertiesInternal deserializedSharePropertiesInternal = new SharePropertiesInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.eTag = reader.getStringElement();
                    continue;
                }
                if ("Quota".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.quota = reader.getIntElement();
                    continue;
                }
                if ("ProvisionedIops".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedIops = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedIngressMBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedIngressMBps = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedEgressMBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedEgressMBps = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedBandwidthMiBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedBandwidthMiBps = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("NextAllowedQuotaDowngradeTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.nextAllowedQuotaDowngradeTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.remainingRetentionDays = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("AccessTier".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTier = reader.getStringElement();
                    continue;
                }
                if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTierChangeTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("AccessTierTransitionState".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTierTransitionState = reader.getStringElement();
                    continue;
                }
                if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseStatus = LeaseStatusType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseState = LeaseStateType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseDuration = LeaseDurationType.fromString(reader.getStringElement());
                    continue;
                }
                if ("EnabledProtocols".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.enabledProtocols = reader.getStringElement();
                    continue;
                }
                if ("RootSquash".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.rootSquash = ShareRootSquash.fromString(reader.getStringElement());
                    continue;
                }
                if ("EnableSnapshotVirtualDirectoryAccess".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.enableSnapshotVirtualDirectoryAccess = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedSharePropertiesInternal.metadata == null) {
                            deserializedSharePropertiesInternal.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedSharePropertiesInternal.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSharePropertiesInternal;
        });
    }
}

