/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareStats
implements XmlSerializable<ShareStats> {
    private long shareUsageBytes;

    public long getShareUsageBytes() {
        return this.shareUsageBytes;
    }

    public ShareStats setShareUsageBytes(long shareUsageBytes) {
        this.shareUsageBytes = shareUsageBytes;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ShareStats" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("ShareUsageBytes", this.shareUsageBytes);
        return xmlWriter.writeEndElement();
    }

    public static ShareStats fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareStats.fromXml(xmlReader, null);
    }

    public static ShareStats fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ShareStats" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareStats deserializedShareStats = new ShareStats();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("ShareUsageBytes".equals(elementName.getLocalPart())) {
                    deserializedShareStats.shareUsageBytes = reader.getLongElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareStats;
        });
    }
}

