/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.BuilderUtils;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.MetadataValidationPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import com.azure.storage.common.sas.CommonSasQueryParameters;
import com.azure.storage.file.share.implementation.util.FileHeadersAndQueryParameters;
import com.azure.storage.file.share.models.ShareAudience;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class BuilderHelper {
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final Pattern IP_URL_PATTERN;

    public static HttpPipeline buildPipeline(StorageSharedKeyCredential storageSharedKeyCredential, TokenCredential tokenCredential, AzureSasCredential azureSasCredential, String sasToken, String endpoint, RequestRetryOptions retryOptions, RetryOptions coreRetryOptions, HttpLogOptions logOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, Configuration configuration, ShareAudience audience, ClientLogger logger) {
        HttpPipelinePolicy credentialPolicy;
        CredentialValidator.validateSingleCredentialIsPresent(storageSharedKeyCredential, tokenCredential, azureSasCredential, sasToken, logger);
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(BuilderHelper.getUserAgentPolicy(configuration, logOptions, clientOptions));
        policies.add(new RequestIdPolicy());
        policies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(BuilderUtils.createRetryPolicy(retryOptions, coreRetryOptions, logger));
        policies.add(new AddDatePolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions(clientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.add(new MetadataValidationPolicy());
        if (storageSharedKeyCredential != null) {
            credentialPolicy = new StorageSharedKeyCredentialPolicy(storageSharedKeyCredential);
        } else if (tokenCredential != null) {
            BuilderHelper.httpsValidation(tokenCredential, "bearer token", endpoint, logger);
            String scope = audience != null ? (audience.toString().endsWith("/") ? audience + ".default" : audience + "/.default") : "https://storage.azure.com/.default";
            credentialPolicy = new BearerTokenAuthenticationPolicy(tokenCredential, scope);
        } else {
            credentialPolicy = azureSasCredential != null ? new AzureSasCredentialPolicy(azureSasCredential, false) : (sasToken != null ? new AzureSasCredentialPolicy(new AzureSasCredential(sasToken), false) : null);
        }
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).clientOptions(clientOptions).tracer(BuilderHelper.createTracer(clientOptions)).build();
    }

    private static UserAgentPolicy getUserAgentPolicy(Configuration configuration, HttpLogOptions logOptions, ClientOptions clientOptions) {
        configuration = configuration == null ? Configuration.NONE : configuration;
        String applicationId = CoreUtils.getApplicationId(clientOptions, logOptions);
        return new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, configuration);
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        HttpLogOptions defaultOptions = new HttpLogOptions();
        FileHeadersAndQueryParameters.getFileHeaders().forEach(defaultOptions::addAllowedHeaderName);
        FileHeadersAndQueryParameters.getFileQueryParameters().forEach(defaultOptions::addAllowedQueryParamName);
        return defaultOptions;
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").build();
    }

    public static String getAccountName(URL url) {
        if (IP_URL_PATTERN.matcher(url.getHost()).find()) {
            String[] pathPieces;
            String path = url.getPath();
            if (!CoreUtils.isNullOrEmpty(path) && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            return (pathPieces = path.split("/", 1)).length == 1 ? pathPieces[0] : null;
        }
        String host = url.getHost();
        if (CoreUtils.isNullOrEmpty(host)) {
            return null;
        }
        int accountNameIndex = host.indexOf(46);
        if (accountNameIndex == -1) {
            return host;
        }
        return host.substring(0, accountNameIndex);
    }

    public static void httpsValidation(Object objectToCheck, String objectName, String endpoint, ClientLogger logger) {
        if (objectToCheck != null && !BuilderHelper.parseEndpoint(endpoint, logger).getScheme().equals("https")) {
            throw logger.logExceptionAsError(new IllegalArgumentException("Using a(n) " + objectName + " requires https"));
        }
    }

    public static ShareUrlParts parseEndpoint(String endpoint, ClientLogger logger) {
        Objects.requireNonNull(endpoint);
        try {
            URL url = new URL(endpoint);
            ShareUrlParts parts = new ShareUrlParts().setScheme(url.getProtocol());
            if (BuilderHelper.determineAuthorityIsIpStyle(url.getAuthority())) {
                String path = url.getPath();
                if (!CoreUtils.isNullOrEmpty(path) && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                String[] pathPieces = path.split("/", 2);
                parts.setAccountName(pathPieces[0]);
                if (pathPieces.length == 2) {
                    parts.setShareName(pathPieces[1]);
                }
                parts.setEndpoint(url.getProtocol() + "://" + url.getAuthority() + "/" + parts.getAccountName());
            } else {
                String host = url.getHost();
                String accountName = null;
                if (!CoreUtils.isNullOrEmpty(host)) {
                    int accountNameIndex = host.indexOf(46);
                    accountName = accountNameIndex == -1 ? host : host.substring(0, accountNameIndex);
                }
                parts.setAccountName(accountName);
                String[] pathSegments = url.getPath().split("/", 2);
                if (pathSegments.length == 2 && !CoreUtils.isNullOrEmpty(pathSegments[1])) {
                    parts.setShareName(pathSegments[1]);
                }
                parts.setEndpoint(url.getProtocol() + "://" + url.getAuthority());
            }
            String sasToken = new CommonSasQueryParameters(SasImplUtils.parseQueryString(url.getQuery()), false).encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                parts.setSasToken(sasToken);
            }
            return parts;
        }
        catch (MalformedURLException ex) {
            throw logger.logExceptionAsError(new IllegalArgumentException("The Azure Storage Share endpoint url is malformed.", ex));
        }
    }

    public static boolean determineAuthorityIsIpStyle(String authority) throws MalformedURLException {
        return new URL("http://" + authority).getPort() != -1;
    }

    private static Tracer createTracer(ClientOptions clientOptions) {
        TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
        return TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, "Microsoft.Storage", tracingOptions);
    }

    static {
        Map<String, String> properties = CoreUtils.getProperties("azure-storage-file-share.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        IP_URL_PATTERN = Pattern.compile("(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(?:localhost)");
    }

    public static class ShareUrlParts {
        private String scheme;
        private String endpoint;
        private String accountName;
        private String shareName;
        private String sasToken;

        public String getScheme() {
            return this.scheme;
        }

        public ShareUrlParts setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public ShareUrlParts setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public ShareUrlParts setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public String getShareName() {
            return this.shareName;
        }

        ShareUrlParts setShareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        public String getSasToken() {
            return this.sasToken;
        }

        public ShareUrlParts setSasToken(String sasToken) {
            this.sasToken = sasToken;
            return this;
        }
    }
}

