/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class Range
implements XmlSerializable<Range> {
    private long start;
    private long end;

    public long getStart() {
        return this.start;
    }

    public Range setStart(long start) {
        this.start = start;
        return this;
    }

    public long getEnd() {
        return this.end;
    }

    public Range setEnd(long end) {
        this.end = end;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Range" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Start", this.start);
        xmlWriter.writeLongElement("End", this.end);
        return xmlWriter.writeEndElement();
    }

    public static Range fromXml(XmlReader xmlReader) throws XMLStreamException {
        return Range.fromXml(xmlReader, null);
    }

    public static Range fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Range" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            Range deserializedRange = new Range();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedRange.start = reader.getLongElement();
                    continue;
                }
                if ("End".equals(elementName.getLocalPart())) {
                    deserializedRange.end = reader.getLongElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedRange;
        });
    }
}

