/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.models.ShareSmbSettings;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareProtocolSettings
implements XmlSerializable<ShareProtocolSettings> {
    private ShareSmbSettings smb;

    public ShareSmbSettings getSmb() {
        return this.smb;
    }

    public ShareProtocolSettings setSmb(ShareSmbSettings smb) {
        this.smb = smb;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ProtocolSettings" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.smb, "SMB");
        return xmlWriter.writeEndElement();
    }

    public static ShareProtocolSettings fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareProtocolSettings.fromXml(xmlReader, null);
    }

    public static ShareProtocolSettings fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ProtocolSettings" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareProtocolSettings deserializedShareProtocolSettings = new ShareProtocolSettings();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SMB".equals(elementName.getLocalPart())) {
                    deserializedShareProtocolSettings.smb = ShareSmbSettings.fromXml(reader, "SMB");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareProtocolSettings;
        });
    }
}

