/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.models.SmbMultichannel;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareSmbSettings
implements XmlSerializable<ShareSmbSettings> {
    private SmbMultichannel multichannel;

    public SmbMultichannel getMultichannel() {
        return this.multichannel;
    }

    public ShareSmbSettings setMultichannel(SmbMultichannel multichannel) {
        this.multichannel = multichannel;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SMB" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.multichannel, "Multichannel");
        return xmlWriter.writeEndElement();
    }

    public static ShareSmbSettings fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareSmbSettings.fromXml(xmlReader, null);
    }

    public static ShareSmbSettings fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SMB" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareSmbSettings deserializedShareSmbSettings = new ShareSmbSettings();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Multichannel".equals(elementName.getLocalPart())) {
                    deserializedShareSmbSettings.multichannel = SmbMultichannel.fromXml(reader, "Multichannel");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareSmbSettings;
        });
    }
}

