/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import com.azure.storage.file.share.models.ShareFileItem;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NormalizedOperations
implements RemoteFileOperations<ShareFileItem> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RemoteFileConfiguration configuration;

    protected NormalizedOperations(RemoteFileConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public final boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        this.log.trace("buildDirectory({},{})", (Object)directory, (Object)absolute);
        directory = this.configuration.normalizePath(directory);
        if (absolute) {
            return this.buildDirectory(directory);
        }
        throw new IllegalArgumentException("Relative path: " + directory);
    }

    protected abstract boolean buildDirectory(String var1);
}

