/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.Changefeed;
import com.azure.storage.blob.changefeed.SegmentFactory;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.util.TimeUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.OffsetDateTime;

class ChangefeedFactory {
    private static final ClientLogger LOGGER = new ClientLogger(ChangefeedFactory.class);
    private final SegmentFactory segmentFactory;
    final BlobContainerAsyncClient client;

    ChangefeedFactory(SegmentFactory segmentFactory, BlobContainerAsyncClient client) {
        StorageImplUtils.assertNotNull("segmentFactory", segmentFactory);
        StorageImplUtils.assertNotNull("client", client);
        this.segmentFactory = segmentFactory;
        this.client = client;
    }

    Changefeed getChangefeed(OffsetDateTime startTime, OffsetDateTime endTime) {
        OffsetDateTime start = startTime == null ? OffsetDateTime.MIN : startTime;
        OffsetDateTime end = endTime == null ? OffsetDateTime.MAX : endTime;
        return new Changefeed(this.client, start, end, null, this.segmentFactory);
    }

    Changefeed getChangefeed(String cursor) {
        StorageImplUtils.assertNotNull("cursor", cursor);
        ChangefeedCursor userCursor = ChangefeedCursor.deserialize(cursor, LOGGER);
        OffsetDateTime start = TimeUtils.convertPathToTime(userCursor.getCurrentSegmentCursor().getSegmentPath());
        OffsetDateTime end = userCursor.getEndTime();
        return new Changefeed(this.client, start, end, userCursor, this.segmentFactory);
    }
}

