/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.changefeed.implementation.models.BlobChangefeedEventWrapper;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.models.InternalBlobChangefeedEvent;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.internal.avro.implementation.AvroReader;
import reactor.core.publisher.Flux;

class Chunk {
    private final String chunkPath;
    private final ChangefeedCursor changefeedCursor;
    private final AvroReader avroReader;

    Chunk(String chunkPath, ChangefeedCursor changefeedCursor, AvroReader avroReader) {
        StorageImplUtils.assertNotNull("chunkPath", chunkPath);
        StorageImplUtils.assertNotNull("changefeedCursor", changefeedCursor);
        StorageImplUtils.assertNotNull("avroReader", avroReader);
        this.chunkPath = chunkPath;
        this.changefeedCursor = changefeedCursor;
        this.avroReader = avroReader;
    }

    Flux<BlobChangefeedEventWrapper> getEvents() {
        return this.avroReader.read().map(avroObject -> {
            long blockOffset = avroObject.getNextBlockOffset();
            long eventIndex = avroObject.getNextObjectIndex();
            Object object = avroObject.getObject();
            ChangefeedCursor eventCursor = this.changefeedCursor.toEventCursor(this.chunkPath, blockOffset, eventIndex);
            InternalBlobChangefeedEvent event = InternalBlobChangefeedEvent.fromRecord(object);
            return new BlobChangefeedEventWrapper(event, eventCursor);
        });
    }
}

