/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public class ShardCursor
implements JsonSerializable<ShardCursor> {
    private String currentChunkPath;
    private long blockOffset;
    private long eventIndex;

    public ShardCursor() {
    }

    public ShardCursor(String currentChunkPath, long blockOffset, long eventIndex) {
        this.currentChunkPath = currentChunkPath;
        this.blockOffset = blockOffset;
        this.eventIndex = eventIndex;
    }

    public String getCurrentChunkPath() {
        return this.currentChunkPath;
    }

    public long getBlockOffset() {
        return this.blockOffset;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }

    public ShardCursor setCurrentChunkPath(String currentChunkPath) {
        this.currentChunkPath = currentChunkPath;
        return this;
    }

    public ShardCursor setBlockOffset(long blockOffset) {
        this.blockOffset = blockOffset;
        return this;
    }

    public ShardCursor setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("CurrentChunkPath", this.currentChunkPath).writeLongField("BlockOffset", this.blockOffset).writeLongField("EventIndex", this.eventIndex).writeEndObject();
    }

    public static ShardCursor fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ShardCursor shardCursor = new ShardCursor();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("CurrentChunkPath".equals(fieldName)) {
                    shardCursor.currentChunkPath = reader.getString();
                    continue;
                }
                if ("BlockOffset".equals(fieldName)) {
                    shardCursor.blockOffset = reader.getLong();
                    continue;
                }
                if ("EventIndex".equals(fieldName)) {
                    shardCursor.eventIndex = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return shardCursor;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardCursor)) {
            return false;
        }
        ShardCursor cursor = (ShardCursor)o;
        return this.getBlockOffset() == cursor.getBlockOffset() && this.getEventIndex() == cursor.getEventIndex() && Objects.equals(this.getCurrentChunkPath(), cursor.getCurrentChunkPath());
    }

    public int hashCode() {
        return Objects.hash(this.getCurrentChunkPath(), this.getBlockOffset(), this.getEventIndex());
    }
}

