/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.SharedExecutorService;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.TimeAndFormat;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Mono;

public class StorageImplUtils {
    private static final ClientLogger LOGGER = new ClientLogger(StorageImplUtils.class);
    private static final String ARGUMENT_NULL_OR_EMPTY = "The argument must not be null or an empty string. Argument name: %s.";
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private static final String STRING_TO_SIGN_LOG_INFO_MESSAGE = "The string to sign computed by the SDK is: {}{}";
    private static final String STRING_TO_SIGN_LOG_WARNING_MESSAGE = "Please remember to disable '{}' before going to production as this string can potentially contain PII.";
    private static final String STORAGE_EXCEPTION_LOG_STRING_TO_SIGN_MESSAGE = String.format("If you are using a StorageSharedKeyCredential, and the server returned an error message that says 'Signature did not match', you can compare the string to sign with the one generated by the SDK. To log the string to sign, pass in the context key value pair '%s': true to the appropriate method call.%nIf you are using a SAS token, and the server returned an error message that says 'Signature did not match', you can compare the string to sign with the one generated by the SDK. To log the string to sign, pass in the context key value pair '%s': true to the appropriate generateSas method call.%nPlease remember to disable '%s' before going to production as this string can potentially contain PII.%n", "Azure-Storage-Log-String-To-Sign", "Azure-Storage-Log-String-To-Sign", "Azure-Storage-Log-String-To-Sign");
    private static final String INVALID_BASE64_KEY = "'base64Key' was not a valid Base64 scheme. Ensure the Storage account key or SAS key is properly formatted.";
    private static final String INVALID_DATE_STRING = "Invalid Date String: %s.";
    private static final String MAX_PRECISION_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int MAX_PRECISION_DATESTRING_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS".replaceAll("'", "").length();
    private static final DateTimeFormatter MAX_PRECISION_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withLocale(Locale.ROOT);
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withLocale(Locale.ROOT);
    private static final DateTimeFormatter NO_SECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm'Z'").withLocale(Locale.ROOT);
    private static final DateTimeFormatter NO_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.ROOT);
    private static final String ENCRYPTION_DATA_KEY = "encryptiondata";

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        TreeMap<String, String[]> pieces = new TreeMap<String, String[]>();
        if (CoreUtils.isNullOrEmpty(queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf(61);
            String key = Utility.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            String[] value = kvp.substring(equalIndex + 1).split(",");
            for (int i = 0; i < value.length; ++i) {
                value[i] = Utility.urlDecode(value[i]);
            }
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static <T> T blockWithOptionalTimeout(Mono<T> response, Duration timeout) {
        if (timeout == null) {
            return response.block();
        }
        return response.block(timeout);
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new NullPointerException(String.format(Locale.ROOT, ARGUMENT_NULL_OR_EMPTY, param));
        }
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, param, min, max)));
        }
    }

    public static String computeHMac256(String base64Key, String stringToSign) {
        byte[] key;
        try {
            key = Base64.getDecoder().decode(base64Key);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(INVALID_BASE64_KEY, ex);
        }
        try {
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSHA256.doFinal(utf8Bytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL appendToUrlPath(String baseURL, String name) {
        UrlBuilder builder = UrlBuilder.parse(baseURL);
        if (builder.getPath() == null) {
            builder.setPath("/");
        } else if (!builder.getPath().endsWith("/")) {
            builder.setPath(builder.getPath() + "/");
        }
        builder.setPath(builder.getPath() + name);
        try {
            return builder.toUrl();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String getAccountName(URL url) {
        UrlBuilder builder = UrlBuilder.parse(url);
        String accountName = null;
        String host = builder.getHost();
        if (!CoreUtils.isNullOrEmpty(host)) {
            int accountNameIndex = host.indexOf(46);
            accountName = accountNameIndex == -1 ? host : host.substring(0, accountNameIndex);
        }
        return accountName;
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public static void logStringToSign(ClientLogger logger, String stringToSign, Context context) {
        if (context != null && Boolean.TRUE.equals(context.getData("Azure-Storage-Log-String-To-Sign").orElse(false))) {
            logger.info(STRING_TO_SIGN_LOG_INFO_MESSAGE, stringToSign, System.lineSeparator());
            logger.warning(STRING_TO_SIGN_LOG_WARNING_MESSAGE, "Azure-Storage-Log-String-To-Sign");
        }
    }

    public static String convertStorageExceptionMessage(String message, HttpResponse response) {
        if (response != null) {
            int indexOfEmptyBody;
            if (response.getStatusCode() == 403) {
                return STORAGE_EXCEPTION_LOG_STRING_TO_SIGN_MESSAGE + message;
            }
            if (response.getRequest() != null && response.getRequest().getHttpMethod() != null && response.getRequest().getHttpMethod().equals((Object)HttpMethod.HEAD) && response.getHeaders().getValue("x-ms-error-code") != null && (indexOfEmptyBody = message.indexOf("(empty body)")) >= 0) {
                return message.substring(0, indexOfEmptyBody) + response.getHeaders().getValue("x-ms-error-code") + message.substring(indexOfEmptyBody + 12);
            }
        }
        return message;
    }

    public static TimeAndFormat parseDateAndFormat(String dateString) {
        DateTimeFormatter formatter = MAX_PRECISION_FORMATTER;
        switch (dateString.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                dateString = dateString.substring(0, MAX_PRECISION_DATESTRING_LENGTH);
                break;
            }
            case 23: {
                if (!dateString.endsWith("Z")) break;
                dateString = dateString.substring(0, 22) + "0";
                break;
            }
            case 22: {
                if (!dateString.endsWith("Z")) break;
                dateString = dateString.substring(0, 21) + "00";
                break;
            }
            case 20: {
                formatter = ISO8601_FORMATTER;
                break;
            }
            case 17: {
                formatter = NO_SECONDS_FORMATTER;
                break;
            }
            case 10: {
                return new TimeAndFormat(LocalDate.parse(dateString).atStartOfDay(ZoneOffset.UTC).toOffsetDateTime(), NO_TIME_FORMATTER);
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, INVALID_DATE_STRING, dateString));
            }
        }
        return new TimeAndFormat(LocalDateTime.parse(dateString, formatter).atZone(ZoneOffset.UTC).toOffsetDateTime(), formatter);
    }

    public static Iterator<Map.Entry<String, String>> parseQueryParameters(String queryParameters) {
        return CoreUtils.isNullOrEmpty(queryParameters) ? Collections.emptyIterator() : new QueryParameterIterator(queryParameters);
    }

    public static <T> T submitThreadPool(Supplier<T> operation, ClientLogger logger, Duration timeout) {
        try {
            return (T)(timeout != null ? SharedExecutorService.getInstance().submit(operation::get).get(timeout.toMillis(), TimeUnit.MILLISECONDS) : operation.get());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw logger.logExceptionAsError(new RuntimeException(e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    public static String getEncryptionDataKey(Map<String, String> metadata) {
        if (CoreUtils.isNullOrEmpty(metadata)) {
            return null;
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (entry.getKey().length() != ENCRYPTION_DATA_KEY.length() || !ENCRYPTION_DATA_KEY.regionMatches(true, 0, entry.getKey(), 0, ENCRYPTION_DATA_KEY.length())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static <T> T sendRequest(Callable<T> operation, Duration timeout, Class<? extends RuntimeException> exceptionType) {
        try {
            if (timeout == null) {
                return operation.call();
            }
            Future<T> future = SharedExecutorService.getInstance().submit(operation);
            return StorageImplUtils.getResultWithTimeout(future, timeout.toMillis(), exceptionType);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (exceptionType.isInstance(e)) {
                throw exceptionType.cast(e);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(cause));
        }
    }

    public static <T> T getResultWithTimeout(Future<T> future, long timeoutInMillis, Class<? extends RuntimeException> exceptionType) throws InterruptedException, ExecutionException, TimeoutException {
        Objects.requireNonNull(future, "'future' cannot be null.");
        try {
            if (timeoutInMillis <= 0L) {
                return future.get();
            }
            return future.get(timeoutInMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (exceptionType.isInstance(cause)) {
                throw e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static final class QueryParameterIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String queryParameters;
        private final int queryParametersLength;
        private boolean done = false;
        private int position;

        QueryParameterIterator(String queryParameters) {
            this.queryParameters = queryParameters;
            this.queryParametersLength = queryParameters.length();
            this.position = queryParameters.startsWith("?") ? 1 : 0;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Map.Entry<String, String> next() {
            char c;
            int nextPosition;
            if (this.done) {
                throw new NoSuchElementException();
            }
            for (nextPosition = this.position; nextPosition < this.queryParametersLength && (c = this.queryParameters.charAt(nextPosition)) != '='; ++nextPosition) {
                if (c != '&') continue;
                String key = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
                return new AbstractMap.SimpleImmutableEntry<String, String>(key, "");
            }
            if (nextPosition == this.queryParametersLength) {
                this.done = true;
                return new AbstractMap.SimpleImmutableEntry<String, String>(this.queryParameters.substring(this.position), "");
            }
            String key = this.queryParameters.substring(this.position, nextPosition);
            this.position = nextPosition + 1;
            nextPosition = this.queryParameters.indexOf(38, this.position);
            String value = null;
            if (nextPosition == -1) {
                this.done = true;
                value = this.queryParameters.substring(this.position);
            } else {
                value = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
        }
    }
}

