/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConstants;
import org.apache.camel.component.azure.storage.blob.BlobConsumer;
import org.apache.camel.component.azure.storage.blob.BlobProducer;
import org.apache.camel.component.azure.storage.blob.client.BlobClientFactory;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.3.0", scheme="azure-storage-blob", title="Azure Storage Blob Service", syntax="azure-storage-blob:accountName/containerName", category={Category.CLOUD, Category.FILE}, headersClass=BlobConstants.class)
public class BlobEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    @UriParam
    private BlobServiceClient blobServiceClient;
    @UriParam
    private BlobConfiguration configuration;

    public BlobEndpoint(String uri, Component component, BlobConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() {
        return new BlobProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty(this.configuration.getContainerName())) {
            throw new IllegalArgumentException("Container name must be set.");
        }
        BlobConsumer consumer = new BlobConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.blobServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : BlobClientFactory.createBlobServiceClient(this.configuration);
    }

    public void setResponseOnExchange(BlobOperationResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody(response.getBody());
        message.setHeaders(response.getHeaders());
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    public BlobServiceClient getBlobServiceClient() {
        return this.blobServiceClient;
    }

    public void setBlobServiceClient(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(this.configuration.getAccountName()) && ObjectHelper.isNotEmpty(this.configuration.getContainerName())) {
            return "azure-storage-blob:" + this.configuration.getAccountName() + "/" + this.configuration.getContainerName();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "storage-blob";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getBlobName() != null) {
            return Map.of("blobName", this.configuration.getBlobName());
        }
        return null;
    }
}

