/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.Block;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.PageRangeItem;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.azure.storage.blob.BlobBlock;
import org.apache.camel.component.azure.storage.blob.BlobCommonRequestOptions;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.blob.BlobConstants;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.component.azure.storage.blob.BlobStreamAndLength;
import org.apache.camel.component.azure.storage.blob.BlobUtils;
import org.apache.camel.component.azure.storage.blob.client.BlobClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BlobOperations.class);
    public static final String MISSING_EXCHANGE = "exchange cannot be null";
    private final BlobClientWrapper client;
    private final BlobConfigurationOptionsProxy configurationProxy;

    public BlobOperations(BlobConfiguration configuration, BlobClientWrapper client) {
        ObjectHelper.notNull(client, "client can not be null.");
        this.client = client;
        this.configurationProxy = new BlobConfigurationOptionsProxy(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobOperationResponse getBlob(Exchange exchange) throws IOException {
        Message message;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting a blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        OutputStream outputStream = ObjectHelper.isEmpty(message = BlobUtils.getInMessage(exchange)) ? null : message.getBody(OutputStream.class);
        BlobRange blobRange = this.configurationProxy.getBlobRange(exchange);
        BlobCommonRequestOptions blobCommonRequestOptions = this.getCommonRequestOptions(exchange);
        if (outputStream == null) {
            Map<String, Object> blobInputStream = this.client.openInputStream(blobRange, (BlobRequestConditions)blobCommonRequestOptions.getBlobRequestConditions());
            BlobExchangeHeaders blobExchangeHeaders = BlobExchangeHeaders.createBlobExchangeHeadersFromBlobProperties((BlobProperties)blobInputStream.get("properties"));
            return BlobOperationResponse.create(blobInputStream.get("inputStream"), blobExchangeHeaders.toMap());
        }
        DownloadRetryOptions downloadRetryOptions = this.getDownloadRetryOptions(this.configurationProxy);
        try {
            ResponseBase<BlobDownloadHeaders, Void> response = this.client.downloadWithResponse(outputStream, blobRange, downloadRetryOptions, (BlobRequestConditions)blobCommonRequestOptions.getBlobRequestConditions(), blobCommonRequestOptions.getContentMD5() != null, blobCommonRequestOptions.getTimeout());
            BlobExchangeHeaders blobExchangeHeaders = BlobExchangeHeaders.createBlobExchangeHeadersFromBlobDownloadHeaders(response.getDeserializedHeaders()).httpHeaders(response.getHeaders());
            BlobOperationResponse blobOperationResponse = BlobOperationResponse.create(outputStream, blobExchangeHeaders.toMap());
            return blobOperationResponse;
        }
        finally {
            if (this.configurationProxy.getConfiguration().isCloseStreamAfterRead()) {
                outputStream.close();
            }
        }
    }

    public BlobOperationResponse downloadBlobToFile(Exchange exchange) {
        String fileDir = this.configurationProxy.getFileDir(exchange);
        if (ObjectHelper.isEmpty(fileDir)) {
            throw new IllegalArgumentException("In order to download a blob, you will need to specify the fileDir in the URI");
        }
        File fileToDownload = new File(fileDir, this.client.getBlobName());
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        BlobRange blobRange = this.configurationProxy.getBlobRange(exchange);
        ParallelTransferOptions parallelTransferOptions = this.configurationProxy.getParallelTransferOptions(exchange);
        DownloadRetryOptions downloadRetryOptions = this.getDownloadRetryOptions(this.configurationProxy);
        Response<BlobProperties> response = this.client.downloadToFileWithResponse(fileToDownload.toString(), blobRange, parallelTransferOptions, downloadRetryOptions, (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getContentMD5() != null, commonRequestOptions.getTimeout());
        BlobExchangeHeaders exchangeHeaders = BlobExchangeHeaders.createBlobExchangeHeadersFromBlobProperties(response.getValue()).httpHeaders(response.getHeaders()).fileName(fileToDownload.toString());
        return BlobOperationResponse.create(fileToDownload, exchangeHeaders.toMap());
    }

    public BlobOperationResponse deleteBlob(Exchange exchange) {
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        DeleteSnapshotsOptionType deleteSnapshotsOptionType = this.configurationProxy.getDeleteSnapshotsOptionType(exchange);
        return BlobOperationResponse.createWithEmptyBody(this.client.delete(deleteSnapshotsOptionType, (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout()));
    }

    public BlobOperationResponse downloadLink(Exchange exchange) {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        long defaultExpirationTime = 3600L;
        BlobSasPermission sasPermission = new BlobSasPermission().setReadPermission(true);
        Long expirationMillis = this.configurationProxy.getDownloadLinkExpiration(exchange);
        OffsetDateTime offsetDateTimeToSet = expirationMillis != null ? offsetDateTime.plusSeconds(expirationMillis / 1000L) : offsetDateTime.plusSeconds(3600L);
        BlobServiceSasSignatureValues serviceSasSignatureValues = new BlobServiceSasSignatureValues(offsetDateTimeToSet, sasPermission);
        String url = this.client.getBlobUrl() + "?" + this.client.generateSas(serviceSasSignatureValues);
        BlobExchangeHeaders headers = BlobExchangeHeaders.create().downloadLink(url);
        return BlobOperationResponse.createWithEmptyBody(headers.toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobOperationResponse uploadBlockBlob(Exchange exchange) throws IOException {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        BlobStreamAndLength blobStreamAndLength = BlobStreamAndLength.createBlobStreamAndLengthFromExchangeBody(exchange);
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Putting a block blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        try {
            Response<BlockBlobItem> response = this.client.uploadBlockBlob(blobStreamAndLength.getInputStream(), blobStreamAndLength.getStreamLength(), commonRequestOptions.getBlobHttpHeaders(), commonRequestOptions.getMetadata(), commonRequestOptions.getAccessTier(), commonRequestOptions.getContentMD5(), (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout());
            BlobOperationResponse blobOperationResponse = BlobOperationResponse.createWithEmptyBody(response);
            return blobOperationResponse;
        }
        finally {
            this.closeInputStreamIfNeeded(blobStreamAndLength.getInputStream());
        }
    }

    public BlobOperationResponse stageBlockBlobList(Exchange exchange) throws Exception {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        Object object = exchange.getIn().getMandatoryBody();
        List<BlobBlock> blobBlocks = null;
        if (object instanceof List) {
            blobBlocks = (List<BlobBlock>)object;
        } else if (object instanceof BlobBlock) {
            blobBlocks = Collections.singletonList((BlobBlock)object);
        }
        if (blobBlocks == null || blobBlocks.isEmpty()) {
            throw new IllegalArgumentException("Illegal storageBlocks payload");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Putting a blob [{}] from blocks from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        LinkedList blockEntries = new LinkedList();
        blobBlocks.forEach(blobBlock -> {
            blockEntries.add(blobBlock.getBlockEntry());
            this.client.stageBlockBlob(blobBlock.getBlockEntry().getName(), blobBlock.getBlockStream(), blobBlock.getBlockEntry().getSizeLong(), commonRequestOptions.getContentMD5(), commonRequestOptions.leaseId(), commonRequestOptions.getTimeout());
        });
        boolean commitBlockListLater = this.configurationProxy.isCommitBlockListLater(exchange);
        if (!commitBlockListLater) {
            exchange.getIn().setBody(blockEntries);
            return this.commitBlobBlockList(exchange);
        }
        return BlobOperationResponse.createWithEmptyBody();
    }

    public BlobOperationResponse commitBlobBlockList(Exchange exchange) throws Exception {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        Object object = exchange.getIn().getMandatoryBody();
        List<Block> blockEntries = null;
        if (object instanceof List) {
            blockEntries = (List<Block>)object;
        } else if (object instanceof Block) {
            blockEntries = Collections.singletonList((Block)object);
        }
        if (blockEntries == null || blockEntries.isEmpty()) {
            throw new IllegalArgumentException("Illegal commit block list payload");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Putting a blob [{}] block list from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        List<String> blockIds = blockEntries.stream().map(Block::getName).toList();
        Response<BlockBlobItem> response = this.client.commitBlockBlob(blockIds, commonRequestOptions.getBlobHttpHeaders(), commonRequestOptions.getMetadata(), commonRequestOptions.getAccessTier(), (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout());
        return BlobOperationResponse.createWithEmptyBody(response);
    }

    public BlobOperationResponse getBlobBlockList(Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting the blob block list [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        BlockListType blockListType = this.configurationProxy.getBlockListType(exchange);
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        Response<BlockList> response = this.client.listBlobBlocks(blockListType, commonRequestOptions.leaseId(), commonRequestOptions.getTimeout());
        return BlobOperationResponse.create(response);
    }

    public BlobOperationResponse createAppendBlob(Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating an append blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        Response<AppendBlobItem> response = this.client.createAppendBlob(commonRequestOptions.getBlobHttpHeaders(), commonRequestOptions.getMetadata(), (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout());
        return BlobOperationResponse.createWithEmptyBody(response);
    }

    public BlobOperationResponse copyBlob(Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating an append blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        String sourceBlobName = this.configurationProxy.getBlobName(exchange);
        String sourceAccountName = exchange.getMessage().getHeader("CamelAzureStorageBlobSourceBlobAccountName", String.class);
        if (ObjectHelper.isEmpty(sourceAccountName)) {
            throw new IllegalArgumentException("Source Account Name must be specified for copyBlob Operation");
        }
        String sourceContainerName = exchange.getMessage().getHeader("CamelAzureStorageBlobSourceBlobContainerName", String.class);
        if (ObjectHelper.isEmpty(sourceAccountName)) {
            throw new IllegalArgumentException("Source Container Name must be specified for copyBlob Operation");
        }
        String response = this.client.copyBlob(sourceBlobName, sourceAccountName, sourceContainerName, this.configurationProxy.getConfiguration().getSourceBlobAccessKey());
        return BlobOperationResponse.create(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobOperationResponse commitAppendBlob(Exchange exchange) throws IOException {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        boolean createAppendBlob = this.configurationProxy.isCreateAppendBlob(exchange);
        if (createAppendBlob && !this.client.appendBlobExists()) {
            this.createAppendBlob(exchange);
        }
        BlobStreamAndLength streamAndLength = BlobStreamAndLength.createBlobStreamAndLengthFromExchangeBody(exchange);
        try {
            Response<AppendBlobItem> response = this.client.appendBlobBlock(streamAndLength.getInputStream(), streamAndLength.getStreamLength(), commonRequestOptions.getContentMD5(), (AppendBlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout());
            BlobOperationResponse blobOperationResponse = BlobOperationResponse.createWithEmptyBody(response);
            return blobOperationResponse;
        }
        finally {
            this.closeInputStreamIfNeeded(streamAndLength.getInputStream());
        }
    }

    public BlobOperationResponse createPageBlob(Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating a page blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        Long pageSize = this.getPageBlobSize(exchange);
        BlobCommonRequestOptions requestOptions = this.getCommonRequestOptions(exchange);
        Long sequenceNumber = this.configurationProxy.getBlobSequenceNumber(exchange);
        Response<PageBlobItem> response = this.client.createPageBlob(pageSize, sequenceNumber, requestOptions.getBlobHttpHeaders(), requestOptions.getMetadata(), (BlobRequestConditions)requestOptions.getBlobRequestConditions(), requestOptions.getTimeout());
        return BlobOperationResponse.createWithEmptyBody(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobOperationResponse uploadPageBlob(Exchange exchange) throws Exception {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        boolean createPageBlob = this.configurationProxy.isCreatePageBlob(exchange);
        if (createPageBlob && !this.client.pageBlobExists()) {
            this.createPageBlob(exchange);
        }
        InputStream is = exchange.getMessage().getMandatoryBody(InputStream.class);
        BlobCommonRequestOptions requestOptions = this.getCommonRequestOptions(exchange);
        PageRange pageRange = this.configurationProxy.getPageRange(exchange);
        if (pageRange == null) {
            throw new IllegalArgumentException("You need to set page range in the exchange headers.");
        }
        try {
            Response<PageBlobItem> response = this.client.uploadPageBlob(pageRange, is, requestOptions.getContentMD5(), (PageBlobRequestConditions)requestOptions.getBlobRequestConditions(), requestOptions.getTimeout());
            BlobOperationResponse blobOperationResponse = BlobOperationResponse.createWithEmptyBody(response);
            return blobOperationResponse;
        }
        finally {
            this.closeInputStreamIfNeeded(is);
        }
    }

    public BlobOperationResponse resizePageBlob(Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resizing a page blob [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        Long pageSize = this.getPageBlobSize(exchange);
        BlobCommonRequestOptions requestOptions = this.getCommonRequestOptions(exchange);
        Response<PageBlobItem> response = this.client.resizePageBlob(pageSize, (BlobRequestConditions)requestOptions.getBlobRequestConditions(), requestOptions.getTimeout());
        return BlobOperationResponse.createWithEmptyBody(response);
    }

    public BlobOperationResponse clearPageBlob(Exchange exchange) {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        PageRange pageRange = this.configurationProxy.getPageRange(exchange);
        BlobCommonRequestOptions requestOptions = this.getCommonRequestOptions(exchange);
        if (pageRange == null) {
            throw new IllegalArgumentException("You need to set page range in the exchange headers.");
        }
        Response<PageBlobItem> response = this.client.clearPagesBlob(pageRange, (PageBlobRequestConditions)requestOptions.getBlobRequestConditions(), requestOptions.getTimeout());
        return BlobOperationResponse.createWithEmptyBody(response);
    }

    public BlobOperationResponse getPageBlobRanges(Exchange exchange) {
        ObjectHelper.notNull(exchange, MISSING_EXCHANGE);
        BlobRange blobRange = this.configurationProxy.getBlobRange(exchange);
        BlobCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting the page blob ranges [{}] from exchange [{}]...", (Object)this.configurationProxy.getBlobName(exchange), (Object)exchange);
        }
        PagedIterable<PageRangeItem> response = this.client.getPageBlobRanges(blobRange, (BlobRequestConditions)commonRequestOptions.getBlobRequestConditions(), commonRequestOptions.getTimeout());
        return BlobOperationResponse.create(response);
    }

    private DownloadRetryOptions getDownloadRetryOptions(BlobConfigurationOptionsProxy configurationProxy) {
        return new DownloadRetryOptions().setMaxRetryRequests(configurationProxy.getMaxRetryRequests());
    }

    private BlobCommonRequestOptions getCommonRequestOptions(Exchange exchange) {
        BlobHttpHeaders blobHttpHeaders = this.configurationProxy.getBlobHttpHeaders(exchange);
        Map<String, String> metadata = this.configurationProxy.getMetadata(exchange);
        AccessTier accessTier = this.configurationProxy.getAccessTier(exchange);
        BlobRequestConditions blobRequestConditions = this.configurationProxy.getBlobRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        byte[] contentMD5 = this.configurationProxy.getContentMd5(exchange);
        return new BlobCommonRequestOptions(blobHttpHeaders, metadata, accessTier, blobRequestConditions, contentMD5, timeout);
    }

    private Long getPageBlobSize(Exchange exchange) {
        PageRange pageRange = this.configurationProxy.getPageRange(exchange);
        if (pageRange != null) {
            return pageRange.getEnd() - pageRange.getStart() + 1L;
        }
        Long pageSize = this.configurationProxy.getPageBlobSize(exchange);
        if (pageSize != null) {
            return pageSize;
        }
        return BlobConstants.PAGE_BLOB_DEFAULT_SIZE;
    }

    private void closeInputStreamIfNeeded(InputStream inputStream) throws IOException {
        if (this.configurationProxy.getConfiguration().isCloseStreamAfterWrite()) {
            inputStream.close();
        }
    }
}

