/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-storage-blob:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure Store Blob get blob information")
public class AzureStorageBlobCloudEventDataTypeTransformer
extends Transformer {
    @Override
    public void transform(Message message, DataType fromType, DataType toType) {
        Map<String, Object> headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.storage.blob.getBlob");
        if (message.getHeaders().containsKey("CamelAzureStorageBlobETag")) {
            headers.put("CamelCloudEventSource", "azure.storage.blob." + message.getHeader("CamelAzureStorageBlobETag", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAzureStorageBlobBlobName", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

